<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="91"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value" />

     <uix:pageLayout titleBinding="pageHeader@fsRestoreBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/restoreTrainMessages.jspf" %>

        <uix:switcher childNameBinding="restoreByBackup@fsRestoreBean@servletRequest">
            <uix:case name="true">
              <%@ include file="/database/ob/obRestoreBkprptInc.jspf" %>
            </uix:case>
            <uix:case name="false">
              <uix:stackLayout>
              <uix:tableLayout width="53%" hAlign="center" cellSpacing="5">
                <uix:switcher childNameBinding="singleHostTask@fsRestoreBean@servletRequest">
                <uix:case name="true">
                 <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:messagePrompt promptBinding="RESTORE_SOURCE_HOST@obBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat columnSpan="2">
                   <uix:messageTextInput
                         name="obHost"
                         styleClass="OraInstructionText"
                         textBinding="obHost@fsRestoreBean@servletRequest"
                         readOnly="true"/>
                  </uix:cellFormat>
                 </uix:rowLayout>
                 </uix:case>
                 <uix:case name="false">
                 <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:messagePrompt promptBinding="RESTORE_SOURCE_HOSTS@obBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat  columnSpan="2">
                    <uix:stackLayout>
                      <uix:lovInput name="selectedHosts" id="lovObHosts"
                         shortDescBinding="RESTORE_SOURCE_HOSTS_TIP@obBundle@servletRequest"
                         textBinding="selectedHosts@fsRestoreBean@servletRequest"
                         columns="40"
                         partialRenderMode="self"
                         destinationBinding="obHostLovUrl@fsRestoreBean@servletRequest"
                         noAutoComplete="true"/>
                       <uix:styledText styleClass="OraInlineInfoText" textBinding="RESTORE_SOURCE_HOSTS_TIP@obBundle@servletRequest"/>
                     </uix:stackLayout>
                   </uix:cellFormat>
                   </uix:rowLayout>
                  </uix:case>
               </uix:switcher>
              </uix:tableLayout>
              <uix:tableLayout width="60%" hAlign="center" cellSpacing="2">
               <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                   <uix:messagePrompt promptBinding="RESTORE_LBL_VIEWBY@obBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat  columnSpan="2">
                  <uix:messageRadioButton name="viewBy" value="latest"
                       selectedValueBinding="viewBy@fsRestoreBean@servletRequest"
                       textBinding="RESTORE_LBL_LATEST@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat> 
               </uix:rowLayout>
               <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top">
                   <uix:messageRadioButton name="viewBy" value="date"
                        selectedValueBinding="viewBy@fsRestoreBean@servletRequest"
                        textBinding="RESTORE_LBL_PRIOR_POINT_IN_TIME@obBundle@servletRequest"
                        styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat>
                   <uix:messageDateField shortDescBinding="dateTip@scheduleBean@servletRequest" name="asofDate" columns="10" valueBinding="asofDate@fsRestoreBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                     <uix:onSubmitValidater>
                       <uix:date dateStyle="medium"/>
                     </uix:onSubmitValidater>
                   </uix:messageDateField>
                </uix:cellFormat>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat>
                </uix:cellFormat>
               </uix:rowLayout>
               <uix:rowLayout>
                <uix:cellFormat>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" >
                   <uix:messageRadioButton name="viewBy" value="daterange"
                        selectedValueBinding="viewBy@fsRestoreBean@servletRequest"
                        textBinding="RESTORE_LBL_FROM_DATE@obBundle@servletRequest"
                        styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat>
                   <uix:messageDateField shortDescBinding="dateTip@scheduleBean@servletRequest" name="fromDate" columns="10" valueBinding="fromDate@fsRestoreBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                     <uix:onSubmitValidater>
                       <uix:date dateStyle="medium"/>
                     </uix:onSubmitValidater>
                   </uix:messageDateField>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top">
                    <uix:messagePrompt promptBinding="RESTORE_LBL_TO_DATE@obBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat>
                   <uix:messageDateField shortDescBinding="dateTip@scheduleBean@servletRequest" name="toDate" columns="10" valueBinding="toDate@fsRestoreBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                     <uix:onSubmitValidater>
                       <uix:date dateStyle="medium"/>
                     </uix:onSubmitValidater>
                   </uix:messageDateField>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="50"/>
                </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>
              </uix:stackLayout>
            </uix:case>
         </uix:switcher>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsRestoreBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsRestoreBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
