<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="93"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout titleBinding="pageHeader@fsRestoreBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/restoreTrainMessages.jspf" %>

    <uix:stackLayout>
       <uix:styledText styleClass="OraInstructionText" 
                       renderedBinding="restoreByBackup@fsRestoreBean@servletRequest"
                       textBinding="RESTORE_CHANGE_DESTINATION_INSTR@obBundle@servletRequest"/>
       <uix:styledText styleClass="OraInstructionText" 
                       renderedBinding="restoreByCatalog@fsRestoreBean@servletRequest"
                       textBinding="RESTORE_CHANGE_DESTINATION_INSTR2@obBundle@servletRequest"/>
       <uix:tableLayout cellSpacing="10">
         <uix:rowLayout>
           <uix:cellFormat>
              <uix:styledText 
                  labeledNodeId="globalRestoreToHost" 
                  textBinding="DESTINATION_HOST@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
           </uix:cellFormat>
           <uix:cellFormat>
              <uix:switcher childNameBinding="showLovForHosts@fsRestoreBean@servletRequest">
                <uix:case name="true">
                    <uix:lovInput name="globalRestoreToHost" id="lovGlobalRestoreToHost"
                         textBinding="globalRestoreToHost@fsRestoreBean@servletRequest"
                         columns="20"
                         destinationBinding="obHostLovUrl@fsRestoreBean@servletRequest"
                         noAutoComplete="true"/>
                </uix:case>
                <uix:default>
                  <oem:choice name="globalRestoreToHost"
                     id="globalRestoreToHost"
                     optionsBinding="obHostList@fsRestoreBean@servletRequest"
                     selectedValueBinding="globalRestoreToHost@fsRestoreBean@servletRequest"/>
                </uix:default>
              </uix:switcher>
           </uix:cellFormat>
           <uix:cellFormat>
             <uix:messageTextInput
                name="globalRestoreToLocation"
                styleClass="OraInstructionText"
                promptBinding="RESTORE_BASE_LOCATION@obBundle@servletRequest"
                textBinding="globalRestoreToLocation@fsRestoreBean@servletRequest"
                />
           </uix:cellFormat>
           <uix:cellFormat>
              <uix:styledText 
                  labeledNodeId="globalDeviceToUse" 
                  textBinding="RESTORE_FROM_DRIVE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
           </uix:cellFormat>
           <uix:cellFormat>
              <uix:choice name="globalDeviceToUse"
                  id="globalDeviceToUse"
                  selectedValueBinding="globalDeviceToUse@fsRestoreBean@servletRequest">
                  <uix:contents childDataBinding="tapeDriveOptions@fsRestoreBean@servletRequest">
                     <uix:option textBinding="text" valueBinding="val" />
                  </uix:contents>
               </uix:choice>
           </uix:cellFormat>
           <uix:cellFormat>
              <uix:submitButton textBinding="APPLY@obBundle@servletRequest" formName="foo" name="event" value="applyGlobalDestination" shortDescBinding="APPLY@obBundle@servletRequest"/>
           </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>
       <uix:spacer height="10px"/>  
       <uix:table name="destinationTable"
                  id="destinationTable"
                   width="100%"
                  tableDataBinding="fileList@restoreSelectionSourceBean@servletRequest"
                  formSubmitted="true"
                  showAll="yes"
                  summaryBinding="RESTORE_SPECIFY_DESTINATION@obBundle@servletRequest"
                  alternateTextBinding="NONE@obBundle@servletRequest">
           <uix:tableFormat tableBanding="rowBanding"/>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="NAME@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
              <uix:flowLayout>
                <uix:image source="/em/images/database/ob/tree_folder.gif" renderedBinding="isFolder"/> 
                <uix:image source="/em/images/database/ob/tree_document.gif" renderedBinding="isFile"/>
                <uix:spacer width="1px"/>
                <uix:styledText textBinding="nameWithoutSeparator"/>
              </uix:flowLayout>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="PATH@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="path"/>
             </uix:contents>
           </uix:column>
           <uix:column renderedBinding="notSingleHostTask@restoreSelectionSourceBean@servletRequest">
             <uix:columnHeader>
               <uix:styledText textBinding="RESTORE_SOURCE_HOST@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="fromHost"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="DESTINATION_HOST@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
                <uix:switcher childNameBinding="showLovForHosts@fsRestoreBean@servletRequest">
                     <uix:case name="true">
                       <uix:lovInput name="restoreToHost" id="lovDestRestoreToHost"
                           textBinding="restoreToHost"
                           renderedBinding="restoreByCatalog@fsRestoreBean@servletRequest"
                           columns="20"
                           destinationBinding="hostLovUrl"
                           noAutoComplete="true"/>
                      </uix:case>
                      <uix:default>
                        <oem:choice name="restoreToHost"
                          optionsBinding="obHostList@fsRestoreBean@servletRequest"
                          renderedBinding="restoreByCatalog@fsRestoreBean@servletRequest"
                         selectedValueBinding="restoreToHost"/>
                      </uix:default>
                    </uix:switcher>
                  <uix:styledText textBinding="restoreToHost" 
                       renderedBinding="restoreByBackup@fsRestoreBean@servletRequest"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="DESTINATION_LOCATION@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
                <uix:textInput name="restoreToLocation"
                       textBinding="restoreToLocation"
                       readOnlyBinding="restoreByBackup@fsRestoreBean@servletRequest"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="RESTORE_FROM_DRIVE@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:choice name="deviceToUse"
                    readOnlyBinding="restoreByBackup@fsRestoreBean@servletRequest"
                    selectedValueBinding="deviceToUse">
                  <uix:contents childDataBinding="tapeDriveOptions@fsRestoreBean@servletRequest">
                     <uix:option textBinding="text" valueBinding="val" />
                  </uix:contents>
               </uix:choice>
             </uix:contents>
           </uix:column>
       </uix:table>                  
       <uix:spacer height="10px"/>
       <uix:messageCheckBox name="isOverwriteExisting"
            textBinding="OP_OVERWRITE_EXISTING@obBundle@servletRequest"
            shortDescBinding="OP_OVERWRITE_EXISTING_TIP@obBundle@servletRequest"
            checkedBinding="isOverwriteExisting@fsRestoreBean@servletRequest" />
       <uix:spacer height="5px"/>
       <uix:messageCheckBox name="isOverwriteInuse"
            textBinding="OP_OVERWRITE_INUSE@obBundle@servletRequest"
            tipBinding="OP_OVERWRITE_INUSE_TIP@obBundle@servletRequest"
            checkedBinding="isOverwriteInuse@fsRestoreBean@servletRequest" />
    </uix:stackLayout>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsRestoreBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsRestoreBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
