<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="94"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout titleBinding="pageHeader@fsRestoreBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/restoreTrainMessages.jspf" %>

       <uix:header textBinding="POLICY@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
               <uix:messageCheckBox name="privilegedRestore"
                   textBinding="OP_PRIVILEGED_RESTORE@obBundle@servletRequest"
                   tipBinding="OP_PRIVILEGED_RESTORE_TIP@obBundle@servletRequest"
                   renderedBinding="allowPrivilegedRestore@fsRestoreBean@servletRequest"
                   checkedBinding="privilegedRestore@restoreOptions@fsRestoreBean@servletRequest" />

            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
          <uix:cellFormat hAlign="left">
            <uix:messagePrompt labeledNodeId="priority"
              promptBinding="OB_BKWIZ_PRI@obBundle@servletRequest"/>

            <oem:choice name="priority"
                 id="priority"
                 shortDescBinding="PRIORITY_TIP@obBundle@servletRequest"
                 optionsBinding="priorityOptions@fsRestoreBean@servletRequest"
                 selectedValueBinding="priority@restoreOptions@fsRestoreBean@servletRequest"/>
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="80%">
            <uix:cellFormat hAlign="left">
               <uix:styledText styleClass="OraInlineInfoText" textBinding="PRIORITY_TIP@obBundle@servletRequest"/>
            </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>
       </uix:header>
       <uix:header textBinding="OTHER_OPTIONS@obBundle@servletRequest"
                   renderedBinding="showNdmpOption@fsRestoreBean@servletRequest">
        <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
               <uix:messageCheckBox name="ndmpIncrRestore"
                   textBinding="OP_NDMP_INCR_RESTORE@obBundle@servletRequest"
                   tipBinding="OP_NDMP_INCR_RESTORE_TIP@obBundle@servletRequest"
                   renderedBinding="showNdmpOption@fsRestoreBean@servletRequest"
                   checkedBinding="ndmpIncrRestore@restoreOptions@fsRestoreBean@servletRequest" />

            </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>
       </uix:header>
       <uix:hideShow id="panelAdvancedOptions"
            formSubmitted="true" 
            disclosedTextBinding="SECURITY_OPTIONS@obBundle@servletRequest"
            undisclosedTextBinding="SHOW_ADV@obBundle@servletRequest"
            unvalidated="false"
            disclosedBinding="showAdvancedOptions@fsRestoreBean@servletRequest"
            renderedBinding="verEqlOrAbove10_2@fsRestoreBean@servletRequest">
         <uix:stackLayout>
         <uix:spacer height="10px"/>
         <uix:styledText styleClass="OraInstructionText" 
                              textBinding="SECURITY_OPTIONS_TIP@obBundle@servletRequest" />
         <uix:spacer height="10px"/>
         <uix:table name="securityOptionsTable"
                    id="securityOptionsTable"
                   width="100%"
                  tableDataBinding="securityOptions@restoreOptions@fsRestoreBean@servletRequest"
                  formSubmitted="true"
                  showAll="yes"
                  alternateTextBinding="NONE@obBundle@servletRequest">
           <uix:tableFormat tableBanding="rowBanding"/>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="LBL_BACKUP_DATE@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="backupDateTimeStr"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="VOLUME_ID@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="volumeID"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="TRANSIENT@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:messageCheckBox name="transient"
                    checkedBinding="transient" />
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="PASSPHRASE@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
                <uix:textInput name="passPhrase"
                     secret="true"
                     textBinding="passPhrase"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="ENC_ALGO@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
                 <uix:messageChoice name="encAlgo"
                      selectedValueBinding="encAlgo">
                         <uix:option textBinding="ENC_ALGO_AES128@obBundle@servletRequest" value="aes128"/>
                         <uix:option textBinding="ENC_ALGO_AES192@obBundle@servletRequest" value="aes192"/>
                         <uix:option textBinding="ENC_ALGO_AES256@obBundle@servletRequest" value="aes256"/>
                 </uix:messageChoice>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="IGNORE_MISMATCH@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:messageCheckBox name="ignoreMismatch"
                    checkedBinding="ignoreMismatch" />
             </uix:contents>
           </uix:column>
         </uix:table>
         <uix:tip>
           <uix:stackLayout>
             <uix:styledText styleClass="OraInstructionText"
                 textBinding="RESTORE_ENCRYPTION_TIP1@obBundle@servletRequest"/>
             <uix:styledText styleClass="OraInstructionText"
                 textBinding="RESTORE_ENCRYPTION_TIP2@obBundle@servletRequest"/>
           </uix:stackLayout>
         </uix:tip>
         </uix:stackLayout>
        </uix:hideShow>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsRestoreBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsRestoreBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
