<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="96"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout titleBinding="pageHeader@fsRestoreBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/restoreTrainMessages.jspf" %>

     <uix:header textBinding="RESTORE_SELECTED_FILES@obBundle@servletRequest">
       <uix:table name="reviewTable"
                  id="reviewTable"
                   width="100%"
                  tableDataBinding="fileList@restoreSelectionSourceBean@servletRequest"
                  formSubmitted="false"
                  showAll="yes"
                  summaryBinding="RESTORE_SELECTED_FILES@obBundle@servletRequest"
                  alternateTextBinding="NONE@obBundle@servletRequest">
           <uix:tableFormat tableBanding="rowBanding"/>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="NAME@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
              <uix:flowLayout>
                <uix:image source="/em/images/database/ob/tree_folder.gif" renderedBinding="isFolder" shortDesc="Directory"/>
                <uix:image source="/em/images/database/ob/tree_document.gif" renderedBinding="isFile" shortDesc="File"/>
                <uix:spacer width="1px"/>
               <uix:styledText textBinding="path"/>
                <uix:styledText textBinding="nameWithoutSeparator"/>
              </uix:flowLayout>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="RESTORE_SOURCE_HOST@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="fromHost"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="VERSION_TO_RESTORE@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="backupDateTimeStr"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="DESTINATION_HOST@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="restoreToHost"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="DESTINATION_LOCATION@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:styledText textBinding="restoreToLocation"/>
             </uix:contents>
           </uix:column>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="RESTORE_FROM_DRIVE@obBundle@servletRequest"/>
             </uix:columnHeader>
             <uix:contents>
               <uix:choice name="deviceToUse"
                    readOnly="true"
                    selectedValueBinding="deviceToUse">
                  <uix:contents childDataBinding="tapeDriveOptions@fsRestoreBean@servletRequest">
                     <uix:option textBinding="text" valueBinding="val" />
                  </uix:contents>
               </uix:choice>
             </uix:contents>
           </uix:column>
        </uix:table>
     </uix:header>
     <uix:tableLayout width="100%">
      <uix:rowLayout>
        <uix:cellFormat width="30%" vAlign="top">
          <uix:header textBinding="RESTORE_SPECIFY_DESTINATION@obBundle@servletRequest">
            <uix:tableLayout cellSpacing="10">
             <uix:rowLayout>
              <uix:cellFormat>
                 <uix:messagePrompt promptBinding="OP_OVERWRITE_EXISTING@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                 <uix:switcher childNameBinding="isOverwriteExisting@restoreOptions@fsRestoreBean@servletRequest">
                   <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionText" textBinding="YES@obBundle@servletRequest"/>
                   </uix:case>
                   <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionText" textBinding="NO@obBundle@servletRequest"/>
                   </uix:case>
                 </uix:switcher>
               </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout>
              <uix:cellFormat>
                  <uix:messagePrompt promptBinding="OP_OVERWRITE_INUSE@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                 <uix:switcher childNameBinding="isOverwriteInuse@restoreOptions@fsRestoreBean@servletRequest">
                 <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionText" textBinding="YES@obBundle@servletRequest"/>
                 </uix:case>
                 <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText" textBinding="NO@obBundle@servletRequest"/>
                 </uix:case>
                </uix:switcher>
              </uix:cellFormat>
             </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:cellFormat>
        <uix:cellFormat width="30%" vAlign="top">
          <uix:header textBinding="RESTORE_OPTIONS@obBundle@servletRequest">
            <uix:tableLayout cellSpacing="10">
             <uix:rowLayout renderedBinding="allowPrivilegedRestore@fsRestoreBean@servletRequest">
              <uix:cellFormat>
                 <uix:messagePrompt promptBinding="OP_PRIVILEGED_RESTORE@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                 <uix:switcher childNameBinding="isPrivilegedRestore@restoreOptions@fsRestoreBean@servletRequest">
                   <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionText" textBinding="YES@obBundle@servletRequest"/>
                   </uix:case>
                   <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionText" textBinding="NO@obBundle@servletRequest"/>
                   </uix:case>
                 </uix:switcher>
               </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout>
               <uix:cellFormat>
                  <uix:messagePrompt promptBinding="OB_BKWIZ_PRI@obBundle@servletRequest" />
               </uix:cellFormat>
               <uix:cellFormat>
                  <uix:styledText styleClass="OraInstructionText" textBinding="priority@restoreOptions@fsRestoreBean@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout renderedBinding="showNdmpOption@fsRestoreBean@servletRequest">
              <uix:cellFormat>
                  <uix:messagePrompt promptBinding="OP_NDMP_INCR_RESTORE@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                 <uix:switcher childNameBinding="isNDMPIncrRestore@restoreOptions@fsRestoreBean@servletRequest">
                 <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionText" textBinding="YES@obBundle@servletRequest"/>
                 </uix:case>
                 <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText" textBinding="NO@obBundle@servletRequest"/>
                 </uix:case>
                </uix:switcher>
              </uix:cellFormat>
             </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:cellFormat>
        <uix:cellFormat width="40%" vAlign="top">
          <uix:header textBinding="RESTORE_JOB_DETAILS@obBundle@servletRequest">
            <uix:tableLayout cellSpacing="10">
             <uix:rowLayout>
              <uix:cellFormat>
                  <uix:messagePrompt promptBinding="RESTORE_JOB_NAME@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                    <uix:styledText styleClass="OraInstructionText" textBinding="jobName@fsRestoreBean@servletRequest"/>
              </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout>
              <uix:cellFormat>
                  <uix:messagePrompt promptBinding="RESTORE_JOB_DESC@obBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                    <uix:styledText styleClass="OraInstructionText" textBinding="jobDesc@fsRestoreBean@servletRequest"/>
              </uix:cellFormat>
             </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:cellFormat>
      </uix:rowLayout>
     </uix:tableLayout>
     <uix:spacer height="10"/>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsRestoreBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsRestoreBean@servletRequest"/>
                </uix:contents>
                <uix:submitButton formName="foo" textBinding="SUBMIT_JOB@obBundle@servletRequest" name="event" value="submit" shortDescBinding="SUBMIT_JOB@obBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
