<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="optype@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="1"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="RUN_JOB@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="75%%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="RUN_JOB_SUMMARY@obBundle@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="JOB_ID@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="id@jobItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="RUN@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:radioButton name="runjob" value="now" shortDescBinding="RUN_NOW@obBundle@servletRequest"/>
                <uix:styledText 
                       textBinding="RUN_NOW@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:radioButton name="runjob" value="asap" shortDescBinding="RUN_NOW@obBundle@servletRequest"/>
                <uix:styledText 
                       textBinding="RUN_ASAP@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:radioButton name="runjob" value="priority" shortDescBinding="RUN_NOW@obBundle@servletRequest"/>
                <uix:styledText 
                       textBinding="RUN_PRIORITY@obBundle@servletRequest" 
                       labeledNodeId="priority"
                       styleClass="OraInstructionText" />
                <uix:textInput name="priority" id="priority" columns="4" text="100"/>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="drive"
                       textBinding="JOB_DEVICE@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="drive"
                          id="drive"
                          optionsBinding="drives@jobBean@obBean@servletRequest"/>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="JOB_DEVICE_TIP@obBundle@servletRequest" 
                       styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

      </uix:header>
      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="doRunJob"
                                      formName="foo"/>

                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="okTranscript"
                                      formName="foo"/>
        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
