<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob"  copyParams="target,type"> 

    <uix:formValue name="pageNum" value="52"/>
    <uix:formValue name="adminName" valueBinding="adminNameShort@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="SCANS_PAGE_TITLE@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="SCANS_SUMMARY@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="middle">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:submitButton textBinding="ADD@obBundle@servletRequest" name="event" value="createScan"/>
              </uix:cellFormat>
           </uix:rowLayout>
        <uix:stackLayout>
        <uix:contents>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                id="scanUI"
                name="scanUI"
                dataSourceProp="scanUI"
                beanKey="scanDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedScan@scanBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="EDIT@obBundle@servletRequest"
                      name="event"
                      value="editScan"/>
                  <uix:spacer width="10" />
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="confirmRemoveScan"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:contents>
          </uix:stackLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="MEDIAMOVEMENT_OP_TIP@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="DUPLICATION_OP_TIP@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="LOCATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'50'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="ROTATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'51'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="JOBS_PAGE_TITLE@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'53'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="DUPLICATION_POLICY@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'61'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>


      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
