<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type">
      <uix:formValue name="pageNum" value="19"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest">
            <uix:styledText 
                 labeledNodeId="devicelist" 
                 textBinding="HEADING_VDV@obBundle@servletRequest" 
                 styleClass="OraInstructionText"/>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:textInput 
                       name="deviceVolumes" 
                       shortDescBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest"
                       textBinding="deviceVolumes@devicesBean@obBean@servletRequest" 
                       readOnly="true"
                       wrap="false"
                       columns="120" 
                       rows="15"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
       </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:flowLayout>
                <uix:submitButton 
                   textBinding="OK@obBundle@servletRequest" 
                   name="event" 
                   value="manageDevices"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
