<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="jid" valueBinding="id@reportItem@jobBean@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="60"/>

     <uix:pageLayout titleBinding="VIEW_REPORT@obBundle@servletRequest">
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="text@obBean@servletRequest">
        <uix:tableLayout cellSpacing="5" width="80%">
           <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="JOB_ID@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="id@jobItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="STATE@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="state@jobItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="PRODUCT@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="product@reportItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="CUSTOMER_ID@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="customerID@reportItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="LOCATION@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="location@reportItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
           </uix:rowLayout>
        </uix:tableLayout>

            <oem:table
                width="80%"
                blockSize="25"
                formSubmitted="true"
                id="reportUI"
                name="reportUI"
                dataSourceProp="reportUI"
                beanKey="reportDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
            </oem:table>
      </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="okTranscript"
                                      formName="foo"/>
        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
