<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="optype@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="1"/>

     <uix:pageLayout titleBinding="VIEW_MEDIA_MOVEMENT_LABEL@obBundle@servletRequest">
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="VIEW_MEDIA_MOVEMENT_LABEL@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="75%%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="VIEW_MEDIA_MOVEMENT_SUMMARY@obBundle@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

          <uix:tableLayout cellSpacing="5" width="80%">
             <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="JOB_ID@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="id@jobItem@jobBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="20%">
              <uix:styledText labeledNodeId="level" textBinding="TRANSCRIPT_LEVEL@obBundle@servletRequest" styleClass="OraInstructionText" />

            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:choice name="level" id="level" onChange="submitForm('foo', true, {'event':'viewTranscript'})" selectedValueBinding="level@jobBean@obBean@servletRequest">
                <uix:option textBinding="TRANSCRIPT_LEVEL_DEBUG2@obBundle@servletRequest" value="0"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_DEBUG1@obBundle@servletRequest" value="1"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_VERBOSE@obBundle@servletRequest" value="2"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_INFO@obBundle@servletRequest" value="3"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_REQUEST@obBundle@servletRequest" value="4"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_SUMMARY@obBundle@servletRequest" value="5"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_WARNING@obBundle@servletRequest" value="6"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_ERROR@obBundle@servletRequest" value="7"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_ABORT@obBundle@servletRequest" value="8"/>
                <uix:option textBinding="TRANSCRIPT_LEVEL_FATAL@obBundle@servletRequest" value="9"/>
              </uix:choice>
             </uix:cellFormat>
            </uix:rowLayout>
             <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput name="trans"
                             styleClass="OraInstructionText"
                             shortDescBinding="MF_RETAIN_TIME@obBundle@servletRequest"
                             columns="80"
                             rows="20"
                             readOnly="true"
                             textBinding="text@obBean@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

     <uix:switcher childNameBinding="waiting@jobItem@jobBean@obBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout cellSpacing="5" width="80%">
           <uix:rowLayout>
            <uix:cellFormat hAlign="right">
                <uix:styledText 
                      textBinding="REPLY_TEXT@obBundle@servletRequest" 
                      styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="middle" width="75%">
                  <uix:textInput name="reply" id="reply" columns="15"/>
                  <uix:submitButton textBinding="SUBMIT@obBundle@servletRequest"
                                      name="event"
                                      value="viewTranscript"
                                      formName="foo"/>
              </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
       </uix:case>
      </uix:switcher>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="okTranscript"
                                      formName="foo"/>
        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
