<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type">
      <uix:formValue name="pageNum" value="78"/>
      <uix:formValue name="vid" valueBinding="vid@volumesBean@obBean@servletRequest"/>

       <style selector=".OraMonoText">
          <property name="font-family">Currier,Currier New</property>
          <property name="font-size">8pt</property>
          <property name="color">#000000</property>
       </style>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="text@obBean@servletRequest">
        <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
           <uix:case name="recall">
             <uix:tableLayout cellSpacing="5" width="80%">
               <uix:rowLayout>
                 <uix:cellFormat hAlign="left" columnSpan="2">
                   <uix:styledText textBinding="RECALL_SUMMARY@obBundle@servletRequest" 
                              styleClass="OraInstructionText"/>
                 </uix:cellFormat>
               </uix:rowLayout>
            </uix:tableLayout>
           </uix:case>
           <uix:case name="editvol">
             <uix:tableLayout cellSpacing="5" width="80%">
               <uix:rowLayout>
                 <uix:cellFormat hAlign="left" columnSpan="2">
                   <uix:styledText textBinding="EDIT_VOLUME_SUMMARY@obBundle@servletRequest" 
                              styleClass="OraInstructionText"/>
                 </uix:cellFormat>
               </uix:rowLayout>
            </uix:tableLayout>
           </uix:case>
         </uix:switcher>
       <uix:tableLayout cellSpacing="5" width="80%">
         <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText
                       textBinding="VID@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="currentVolume@volumesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                <uix:styledText
                       textBinding="CURRENT_LOCATION@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="currentLocation@volumeItem@volumesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                <uix:styledText
                       textBinding="ROTATION_POLICY@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="rotationPolicy@volumeItem@volumesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                <uix:styledText
                       textBinding="DUPLICATION_POLICY@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="duplicationPolicy@volumeItem@volumesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>

        <uix:header textBinding="OB_BKWIZ_OPTIONS@obBundle@servletRequest">
          <uix:spacer height="10"/>
          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="duplicate">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                    <uix:formValue name="volumeCommand" value="duplicateVolume"/>
                    <uix:styledText textBinding="VD_MF_LIST@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <oem:choice name="mfs"
                      id="mfs"
                      optionsBinding="mfs@volumesBean@obBean@servletRequest">
                    </oem:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="VD_MF_LIST_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="priority" textBinding="PRIORITY@obBundle@servletRequest" styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput name="priority"
                             id="priority"
                             shortDescBinding="PRIORITY_TIP@obBundle@servletRequest"
                             columns="5"
                             text="100" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="PRIORITY_TIP@obBundle@servletRequest" styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:messageCheckBox name="migrate"
                                         textBinding="MIGRATE_COLUMN@obBundle@servletRequest"
                                         tipBinding="MIGRATE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout width="100%">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="DEVICE_POOL@obBundle@servletRequest" styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                   <oem:shuttle name="resdev"
                               leadingHeaderBinding="SCAN_LOCATION_TIP1@recoveryBundle@servletRequest"
                               trailingHeaderBinding="SCAN_LOCATION_TIP2@recoveryBundle@servletRequest"
                               size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="alldevices" optionsBinding="devices@obBean@servletRequest" shortDescBinding="SCAN_LOCATION_TIP1@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="selecteddevices" optionsBinding="devices@volumesBean@obBean@servletRequest" shortDescBinding="SELECTED_COLUMNS@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:trailing>
                   </oem:shuttle>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="DEVICE_POOL_TIP@obBundle@servletRequest" styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="recall">
              <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="location" textBinding="TO_LOCATION@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="location"
                      id="location"
                      optionsBinding="locations@volumesBean@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MF_DUPLICATION_POLICY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                    <uix:formValue name="volumeCommand" value="recallVolume"/>
                    <uix:styledText textBinding="IMMEDIATE@obBundle@servletRequest"
                                    labeledNodeId="immediate"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="5%">
                    <uix:checkBox name="immediate" id="immediate" value="yes"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="editvol">
              <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="rot" textBinding="ROTATION_POLICY@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:checkBox name="chrot" shortDescBinding="ROTATION_POLICY@obBundle@servletRequest" value="yes"/>
              <oem:choice name="rot"
                      id="rot"
                      optionsBinding="rotations@volumesBean@obBean@servletRequest"
                      selectedValueBinding="rotationPolicy@volumeItem@volumesBean@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="CHVOL_ROTATION_POLICY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="location" textBinding="CURRENT_LOCATION@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:formValue name="volumeCommand" value="editVolume"/>
              <uix:checkBox name="chloc" shortDescBinding="CURRENT_LOCATION@obBundle@servletRequest" value="yes"/>
              <oem:choice name="location"
                      id="location"
                      optionsBinding="locations@volumesBean@obBean@servletRequest"
                      selectedValueBinding="currentLocation@volumeItem@volumesBean@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="CHVOL_LOCATION_POLICY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

      </uix:header>
    </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton 
                   textBinding="CANCEL@obBundle@servletRequest" 
                   name="event" 
                   value="manageVolumes"/>
                <uix:submitButton 
                   textBinding="OK@obBundle@servletRequest" 
                   name="event" 
                   value="volumeCommand"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
