<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:buildTree nodeID="homePlugin">
    <uix:flowLayout>
    <uix:header textBinding="HEADING_OPERATIONS@obBundle@servletRequest">
      <db:form name="foo1" method="post" destination="/console/database/ob" copyParams="target,type">
         <uix:stackLayout>
            <uix:tableLayout cellSpacing="1" width="80%">
              <uix:rowLayout>
                 <uix:cellFormat hAlign="right"  width="30%">
                   <uix:styledText styleClass="OraPromptText"
                                  textBinding="ACTIVEJ@obBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="center"  width="2%">
		       <uix:spacer width="2"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left"  width="65%">
                   <uix:flowLayout>
                     <uix:image source="/em/images/database/ob/jobrunning.gif" 
                                shortDescBinding="ACTIVE_TIP@obBundle@servletRequest"/>
		     <uix:spacer width="5"/>
                     <uix:link textBinding="active@obBeanHome@servletRequest"
                                       shortDescBinding="ACTIVE_TIP@obBundle@servletRequest"
                                       destinationBinding="activeLink@obBeanHome@servletRequest"/>
                     <uix:flowLayout renderedBinding="showUserInputPending@obBeanHome@servletRequest">
  		        <uix:spacer width="10"/>
                        <uix:image source="/em/images/database/ob/Jobwaitinguserinput.gif" 
                                shortDescBinding="USER_INPUT_REQUIRED_TIP@obBundle@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:link textBinding="userInputPending@obBeanHome@servletRequest"
                           shortDescBinding="USER_INPUT_REQUIRED_TIP@obBundle@servletRequest"
                           destinationBinding="userInputLink@obBeanHome@servletRequest"/>
                     </uix:flowLayout>
                     <uix:flowLayout renderedBinding="showPending@obBeanHome@servletRequest">
		        <uix:spacer width="10"/>
                        <uix:image source="/em/images/database/ob/Jobwaitingforresource.gif" 
                                shortDescBinding="PENDING_RESOURCES_TIP@obBundle@servletRequest"/>
		        <uix:spacer width="5"/>

                        <uix:link textBinding="pending@obBeanHome@servletRequest"
                           shortDescBinding="PENDING_RESOURCES_TIP@obBundle@servletRequest"
                           destinationBinding="pendingLink@obBeanHome@servletRequest"/>
                     </uix:flowLayout>
                   </uix:flowLayout>
                  </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                 <uix:cellFormat hAlign="right"  width="30%">
                   <uix:styledText styleClass="OraPromptText"
                                  textBinding="COMPLETE@obBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="center"  width="2%">
                       <uix:spacer width="2"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left"  width="65%">
                   <uix:flowLayout>
                     <uix:image source="/em/images/completeind_status.gif" 
                                shortDescBinding="COMPLETED_TIP@obBundle@servletRequest"/>
                     <uix:spacer width="5"/>
                     <uix:link textBinding="completedIn24Hours@obBeanHome@servletRequest"
                                       shortDescBinding="COMPLETED_TIP@obBundle@servletRequest"
                                       destinationBinding="completedLink@obBeanHome@servletRequest"/>
                     <uix:flowLayout renderedBinding="showFailed@obBeanHome@servletRequest">
                        <uix:spacer width="10"/>
                        <uix:image source="/em/images/criticalind_status.gif" 
                                shortDescBinding="FAILED_TIP@obBundle@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:link textBinding="failedIn24Hours@obBeanHome@servletRequest"
                                       shortDescBinding="FAILED_TIP@obBundle@servletRequest"
                                       destinationBinding="failedLink@obBeanHome@servletRequest"/>
                      </uix:flowLayout>
                    </uix:flowLayout>
                  </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                        <uix:cellFormat hAlign="right"  width="30%">
                          <uix:styledText styleClass="OraPromptText" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center"  width="2%">
                                             <uix:spacer width="2"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="66%" >
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="LAST_24_HOURS@obBundle@servletRequest"/>
                        </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
         </uix:stackLayout>
       </db:form>
    </uix:header>
    </uix:flowLayout>
</uix:buildTree>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="homeuix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="homeoem" %>

<jsp:include page="/sdk/topTabBarInclude.jsp" />
<jsp:include page="/sdk/bottomTabBarInclude.jsp" />
<jsp:include page="/sdk/alertsInclude.jsp" />

<uix:buildTree scope="request" nodeID="AlertsTables">

  <homeuix:flowLayout>
     <uix:spacer height="10"/>
     <db:form name="foo" method="post" destination="/console/database/ob/osbHome" copyParams="target,type">
     <homeuix:header textBinding="DEVICES@obBundle@servletRequest"> 
         <uix:tableLayout cellSpacing="5" width="100%">
              <uix:switcher childNameBinding="problemDeviceCount@obBeanHome@servletRequest">
                 <uix:case name="0">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="middle">
                          <uix:styledText styleClass="OraPromptText"
                                    textBinding="VIEW_DEVICE@obBundle@servletRequest"/>
                          <uix:spacer width="2"/>
                          <uix:choice name="deviceListOptions"
                              onChange="submitForm('foo', true)"
                              shortDescBinding="VIEW_DEVICE@obBundle@servletRequest"
                              disabledBinding="readOnly@obBeanHome@servletRequest"
                              selectedValueBinding="optype@obBeanHome@servletRequest">
                              <uix:option textBinding="PROBLEM_DEVICES@obBundle@servletRequest" value="probDevices"/>
                              <uix:option textBinding="ACTIVE_DEVICES@obBundle@servletRequest" value="activeDevices"/>
                              <uix:option textBinding="ALL_DEVICES@obBundle@servletRequest" value="allDevices"/>
                          </uix:choice>
                             <uix:spacer width="20"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="PROBLEM@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="problemDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="ACTIVE@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="activeDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="TOTAL@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="allDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                 </uix:case>
                 <uix:default>
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="middle">
                          <uix:styledText styleClass="OraPromptText"
                                    textBinding="VIEW_DEVICE@obBundle@servletRequest"/>
                          <uix:spacer width="2"/>
                          <uix:choice name="deviceListOptions"
                              onChange="submitForm('foo', true)"
                              shortDescBinding="VIEW_DEVICE@obBundle@servletRequest"
                              disabledBinding="readOnly@obBeanHome@servletRequest"
                              selectedValueBinding="optype@obBeanHome@servletRequest">
                              <uix:option textBinding="PROBLEM_DEVICES@obBundle@servletRequest" value="probDevices"/>
                              <uix:option textBinding="ACTIVE_DEVICES@obBundle@servletRequest" value="activeDevices"/>
                              <uix:option textBinding="ALL_DEVICES@obBundle@servletRequest" value="allDevices"/>
                          </uix:choice>
                             <uix:spacer width="10"/>
                             <uix:image source="/em/images/criticalind_status.gif"
                                   shortDescBinding="mediaserverTip@obBeanHome@servletRequest"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="PROBLEM@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="problemDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="ACTIVE@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="activeDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="TOTAL@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="allDeviceCount@devicesBean@obBeanHome@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                 </uix:default>
              </uix:switcher>
         </uix:tableLayout>
               <uix:hGrid id="devicesUI"
                    width="100%"
                    formSubmitted="true"
                    treeDataBinding="treeData@devicesDataSourceBeanHome@servletRequest"
                    columnHeaderDataBinding="columnHeaderData@devicesDataSourceBeanHome@servletRequest"
                    columnFormatsBinding="columnFormatData@devicesDataSourceBeanHome@servletRequest"
                    alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest"
                    summaryBinding="MANAGE_DEVICES@obBundle@servletRequest"
                    proxyBinding="proxy@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="NAME@obBundle@servletRequest"
                          sortableBinding="firstColSortState@devicesDataSourceBeanHome@servletRequest"
                          valueBinding="firstColSortIndex@devicesDataSourceBeanHome@servletRequest"/>
                      </uix:columnHeader>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text"
                      sortableBinding="sortState"
                      valueBinding="sortIndex"/>
                  </uix:columnHeaderStamp>
                  <uix:styledText textBinding="type"/>
                  <uix:styledText textBinding="dte"/>
                  <uix:image sourceBinding="status" shortDescBinding="STATUS@obBundle@servletRequest"/>
                  <uix:styledText textBinding="state"/>
                  <uix:styledText textBinding="clean"/>
                  <uix:styledText textBinding="host"/>
                  <uix:styledText textBinding="vendor"/>
                  <uix:styledText textBinding="firmware"/>

                  <%-- Support for selected item. --%>
                  <uix:formValue name="itemName" valueBinding="text"/>
              </uix:hGrid>
       </homeuix:header>
    </db:form>

                <uix:spacer height="10"/>
                <homeuix:tableLayout width="100%" renderedBinding="showAlertsSection@homePageMainTargetAlerts@servletRequest">
                  <homeuix:rowLayout vAlign="top">
                    <homeuix:cellFormat width="100%">
                      <homeuix:dataScope currentDataBinding="homePageMainTargetAlerts@servletRequest">
                        <homeuix:ref refID="AlertsTable" />
                      </homeuix:dataScope>
                    </homeuix:cellFormat>
                  </homeuix:rowLayout>
                </homeuix:tableLayout>

               <uix:spacer height="10"/>
                <homeuix:tableLayout width="100%" renderedBinding="showAlertsSection@homePageRelatedAlerts@servletRequest">
                  <homeuix:rowLayout vAlign="top">
                    <homeuix:cellFormat width="100%">
                      <homeuix:dataScope currentDataBinding="homePageRelatedAlerts@servletRequest">
                        <homeuix:ref refID="AlertsTable" />
                      </homeuix:dataScope>
                    </homeuix:cellFormat>
                  </homeuix:rowLayout>
                </homeuix:tableLayout>

  </homeuix:flowLayout>
</uix:buildTree>
<%@include file="/sdk/homeInclude.jspf" %>
