<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeBean" %>
<script language="JavaScript" src="/em/database/utils.js"></script>
<script language="JavaScript" src="/em/cabo/jsLibs/TableProxy.js"></script> 
<script language="javascript">
function returnSelect()
{
    target = document.forms[0].<%=CubeBean.ATTRIBUTE_TARGET_FIELD_NAME %>.value
    lenName = "UITable:length";
    if ((document.forms[0][lenName] != null) && (target != null) && (target.length > 0))
    {
        proxy = new TableProxy('UITable');
        selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
            selectItem = "UITable:cellValue:"+selectedIndex
            selectItemValue = document.forms[0][selectItem].value
            window.opener.document.forms[0][target].value = selectItemValue;
        }
    }
    self.close();
}
</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="searchTitle@cubeBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="<%= Event.SEARCH_SELECT_SCHEMA.getPageName() %>"/>
    <uix:formValue name="<%= CubeBean.ATTRIBUTE_TARGET_FIELD_NAME %>"  valueBinding="targetFieldName@cubeBean@servletRequest"/>
    <uix:formValue name="<%= CubeBean.ATTRIBUTE_SEARCH_FACT_TYPE %>"   valueBinding="searchFactType@cubeBean@servletRequest"/>
    <uix:formValue name="<%= CubeBean.ATTRIBUTE_SEARCH_FACT_SCHEMA %>" valueBinding="searchFactSchema@cubeBean@servletRequest"/>
    <uix:formValue name="<%= CubeBean.ATTRIBUTE_SEARCH_OWNER %>" valueBinding="searchOwner@cubeBean@servletRequest"/>
    <uix:pageLayout titleBinding="searchTitle@cubeBean@servletRequest">

      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
        <%-- start of details section --%>
        <uix:spacer height="5" width="5"/>
          <uix:header textBinding="SEC_HEADER_SEARCH@msg" size="1">
          <uix:stackLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                  <uix:styledText textBinding="MSG_TEXT_SEARCH_ITEM@msg"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:styledText textBinding="searchFilterLabel@cubeBean@servletRequest" labeledNodeId="searchFilterLabel"/>
                <uix:textInput name="<%= CubeBean.ATTRIBUTE_SEARCH_FILTER %>" textBinding="searchFilterName@cubeBean@servletRequest" columns="30" id="searchFilterLabel"/>
                  <uix:submitButton textBinding="BUTTON_GO@msg" name="event" valueBinding="searchEvent@cubeBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>
        </uix:header>
        <uix:spacer height="5" width="5"/>
       <uix:header textBinding="SEC_HEADER_RESULTS@msg" size="1">
 
        <uix:table name="<%= CubeBean.ATTRIBUTE_UI_TABLE %>"
                   width="90%"
                   minValue="1"
                   tableDataBinding="rowData@cubeBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeBean@servletRequest"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedIndex@cubeBean@servletRequest" shortDescBinding="COL_HEADER_SELECT@msg"/>
          </uix:tableSelection>

          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="searchColHeader@cubeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeBean.ATTRIBUTE_CELL_VALUE %>"/>
              <uix:formValue name="cellValue" valueBinding="<%= CubeBean.ATTRIBUTE_CELL_VALUE %>"/>
            </uix:contents>
          </uix:column>
      <!-- /uix:singleSelection-->  
        </uix:table>
        </uix:header>
        <uix:spacer height="15" width="5"/>

        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:button textBinding="BUTTON_CANCEL@msg" onClick="self.close()" /><uix:spacer height="1" width="1"/>  
              <uix:submitButton textBinding="BUTTON_SELECT@msg" onClick="returnSelect()" /><uix:spacer height="1" width="5"/>
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
   
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


