<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeAggregationUIBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

      <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_AGGREGATION %>"/>
      <uix:formValue name="<%= CubeAggregationUIBean.ATTRIBUTE_START_INDEX %>" valueBinding="startIndex@cubeAggregationBean@servletRequest" />
      <uix:pageLayout titleBinding="header@cubeBean@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
        <uix:subTabLayout>
          <%-- property tabs --%>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="3">
              <oem:submitLink textBinding="TAB_GENERAL@msg" 
                              shortDescBinding="TAB_GENERAL@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.GENERAL_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/>
              <oem:submitLink textBinding="TAB_DIMENSIONS@msg"
                              shortDescBinding="TAB_DIMENSIONS@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.DIMENSION_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/> 
              <oem:submitLink textBinding="TAB_MEASURES@msg"
                              shortDescBinding="TAB_MEASURES@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.MEASURE_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/> 
              <oem:submitLink textBinding="TAB_AGGREGATION@msg"
                              shortDescBinding="TAB_AGGREGATION@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.AGGREGATION_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/>
            </uix:subTabBar>
          </uix:subTabs>

        <uix:spacer height="15" width="5"/>
          <%-- start of details section --%>
        <uix:table name="<%= CubeAggregationUIBean.ATTRIBUTE_UI_TABLE %>"
                   width="100%"
                   minValue="1"
                   tableDataBinding="cubeAggregationData@cubeAggregationBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeAggregationBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeAggregationBean@servletRequest"
                   summaryBinding="TAB_AGGREGATION@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedIndex@cubeAggregationBean@servletRequest" shortDescBinding="COL_HEADER_SELECT@msg">
              <uix:contents>
              <uix:submitButton textBinding="BUTTON_DELETE@msg" name="event" value="<%= Event.AGGREGATION_DELETE.getEventName() %>" shortDescBinding="BUTTON_DELETE@msg"/><uix:spacer height="1" width="10"/>
              </uix:contents>       
            </uix:singleSelection>  
          </uix:tableSelection>
          <uix:footer>
            <uix:submitButton textBinding="BUTTON_ADD_AGGREGATION@msg" name="event" value="<%= Event.AGGREGATION_ADD.getEventName() %>" shortDescBinding="BUTTON_ADD_AGGREGATION@msg"/>
          </uix:footer>

          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_STATE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText styleClass="OraTipText" textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_STATE %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:switcher childNameBinding="isNewAggregation@cubeAggregationBean@servletRequest">
                <uix:case name="false">
                  <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>"/>
                </uix:case>
                <uix:case name="true">
                  <uix:choice name="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>" selectedValueBinding="cubeMeasureName@cubeAggregationBean@servletRequest" shortDescBinding="COL_HEADER_MEASURE_NAME@msg">
                    <uix:contents childDataBinding="cubeMeasureData@cubeAggregationBean@servletRequest">
                      <uix:option textBinding="textMeasure@cubeAggregationBean@servletRequest" valueBinding="valueMeasure@cubeAggregationBean@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:case>
              </uix:switcher>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DIMENSION_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:switcher childNameBinding="isNewAggregation@cubeAggregationBean@servletRequest">
                <uix:case name="false">
                  <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_DIMENSION_NAME %>"/>
                </uix:case>
                <uix:case name="true">
                  <uix:choice name="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_DIMENSION_NAME %>" shortDescBinding="COL_HEADER_DIMENSION_NAME@msg" 
                              selectedValueBinding="cubeDimensionName@cubeAggregationBean@servletRequest"
                              onChange='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.AGGREGATION_ON_CHANGE.getEventName() + "\'})" %>'>
                    <uix:contents childDataBinding="cubeDimensionData@cubeAggregationBean@servletRequest">
                      <uix:option textBinding="textDimension@cubeAggregationBean@servletRequest" valueBinding="valueDimension@cubeAggregationBean@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:case>
              </uix:switcher>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_OPERATOR@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:choice name="<%= CubeAggregationUIBean.ATTRIBUTE_OPERATOR_SELECTED %>" shortDescBinding="COL_HEADER_OPERATOR@msg"
                          selectedValueBinding="OperatorSelected@cubeAggregationBean@servletRequest"
                          onChange='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.AGGREGATION_ON_CHANGE.getEventName() + "\'})" %>'>
                <uix:contents childDataBinding="cubeAggregationOperatorData@cubeAggregationBean@servletRequest">
                  <uix:option textBinding="textKey@cubeAggregationBean@servletRequest" valueBinding="valueKey@cubeAggregationBean@servletRequest"/>
                </uix:contents>
              </uix:choice>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_ARGUMENT_COLUMN@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:switcher childNameBinding="showArgumentColumnType@cubeAggregationBean@servletRequest">
                <uix:case name="<%= CubeAggregationUIBean.ATTRIBUTE_DIMENSION %>">
                  <uix:choice name="<%= CubeAggregationUIBean.ATTRIBUTE_ARGUMENT_COLUMN_SELECTED %>" selectedValueBinding="ArgumentColumnSelected@cubeAggregationBean@servletRequest" shortDescBinding="COL_HEADER_ARGUMENT_COLUMN@msg">
                    <uix:contents childDataBinding="ArgumentColumnData@cubeAggregationBean@servletRequest">
                      <uix:option textBinding="ArgumentColumnText@cubeAggregationBean@servletRequest" valueBinding="ArgumentColumnValue@cubeAggregationBean@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:case>
                <uix:case name="<%= CubeAggregationUIBean.ATTRIBUTE_FACT_TABLE %>">
                  <uix:choice name="<%= CubeAggregationUIBean.ATTRIBUTE_ARGUMENT_COLUMN_SELECTED %>" selectedValueBinding="ArgumentColumnSelected@cubeAggregationBean@servletRequest" shortDescBinding="COL_HEADER_ARGUMENT_COLUMN@msg">
                    <uix:contents childDataBinding="columnData@cubeBean@servletRequest">
                      <uix:option textBinding="textKeyArgCol@cubeBean@servletRequest" valueBinding="valueKey@cubeBean@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:case>
              </uix:switcher>
            </uix:contents>
          </uix:column>

        <!-- /uix:singleSelection-->  
        </uix:table>
       
          <%-- end of details section --%>
        <uix:spacer height="15" width="5"/>
        </uix:subTabLayout>

        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


