<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeBean" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeDimensionUIBean" %>
<script language="javascript">
function getOwner()
{
   return ("&<%= CubeBean.ATTRIBUTE_SEARCH_OWNER %>=" + document.forms[0].<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA %>.value);
}
function popWindow(event,target)
{
    openWindow(window,
               document.forms[0].action+'&pageName=SearchAndSelect&event='+event+'&<%=CubeBean.ATTRIBUTE_TARGET_FIELD_NAME %>='+target,
               'lovWindow',
               {width:700, height:600},
               true,
               'dialog',
               callBackLov);
}
function callBackLov()
{
}
</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/LOV.js"/>
      </uix:metaContainer>

      <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_DIMENSION_EDIT %>"/>
      <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="selectedIndex@cubeDimBean@servletRequest" />
      <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_STATE %>" valueBinding="stateOfObject@cubeDimBean@servletRequest" />
      <uix:pageLayout titleBinding="pageTitle@cubeDimBean@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
          <%-- start of details section --%>
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/> 
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_DIMENSION_ALIAS@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isNewDimension@cubeDimBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="cubeDimAlias@cubeDimBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:textInput name="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_ALIAS %>" textBinding="cubeDimAlias@cubeDimBean@servletRequest" columns="35" onChange="this.value=this.value.toUpperCase()" shortDescBinding="LABEL_DIMENSION_ALIAS@msg"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_DIMENSION_OWNER@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isNewDimension@cubeDimBean@servletRequest">
                        <uix:case name="false">
                          <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA %>" valueBinding="schemaName@cubeDimBean@servletRequest" />
                          <uix:styledText styleClass="OraDataText" textBinding="schemaName@cubeDimBean@servletRequest" />
                        </uix:case>
                        <uix:case name="true">
                          <uix:lovField name="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA %>" 
                                        shortDescBinding="LABEL_DIMENSION_OWNER@msg"
                                        columns="35"
                                        textBinding="schemaName@cubeDimBean@servletRequest"
                                        searchDescBinding="LABEL_DIMENSION_OWNER@msg"
                                        onClick='<%= "startLov(\'"+CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA + "\', \'ListDimensionOwner\')" %>' />
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_DIMENSION_OBJECT@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isNewDimension@cubeDimBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="cubeDimObject@cubeDimBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:lovField name="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_OBJECT %>" 
                                        shortDescBinding="LABEL_DIMENSION_OBJECT@msg"
                                        columns="35"
                                        textBinding="cubeDimObject@cubeDimBean@servletRequest"
                                        searchDescBinding="LABEL_DIMENSION_OBJECT@msg"
                                        onClick='<%= "setBindSqlParm(\'"+CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA+"\');startLov(\'"+CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_OBJECT + "\', \'ListDimensionObject\')" %>' />
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="isNewDimension@cubeDimBean@servletRequest">
                        <uix:case name="true">
                          <uix:spacer height="1" width="10"/>  
                          <uix:submitButton textBinding="BUTTON_POPULATE_PROPERTY@msg" name="event" value="<%= Event.DIMENSION_POPULATE.getEventName() %>" shortDescBinding="BUTTON_POPULATE_PROPERTY@msg"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_CAL_HIERARCHY@msg" labeledNodeId="LABEL_CAL_HIERARCHY"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:choice name="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_CAL_HIERARCHY %>" selectedValueBinding="cubeDimCalHierarchy@cubeDimBean@servletRequest" id="LABEL_CAL_HIERARCHY">
                          <uix:contents childDataBinding="HierarchyListData@cubeDimBean@servletRequest">
                            <uix:option textBinding="HierarchyListText@cubeDimBean@servletRequest" valueBinding="HierarchyListValue@cubeDimBean@servletRequest"/>
                          </uix:contents>
                        </uix:choice>
                      </uix:contents>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
             
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:header textBinding="SEC_HEADER_JOIN_MAP@msg" size="1">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_JOIN_LEVEL@msg" labeledNodeId="LABEL_JOIN_LEVEL"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:choice name="<%= CubeDimensionUIBean.ATTRIBUTE_LEVEL_NAME %>" selectedValueBinding="levelName@cubeDimBean@servletRequest" id="LABEL_JOIN_LEVEL"
                                    onChange='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.DIMENSION_EDIT_ON_CHANGE.getEventName() + "\'})" %>'>
                          <uix:contents childDataBinding="JoinLevelData@cubeDimBean@servletRequest">
                            <uix:option textBinding="JoinLevelText@cubeDimBean@servletRequest" valueBinding="JoinLevelValue@cubeDimBean@servletRequest"/>
                          </uix:contents>
                        </uix:choice>
                      </uix:contents>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_DIMENSION_TABLE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="levelTableName@cubeDimBean@servletRequest"/>
                      <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_DIMENSION_TABLE %>" valueBinding="levelTableName@cubeDimBean@servletRequest" />
                    </uix:cellFormat> 
                  </uix:rowLayout>
                 </uix:tableLayout>
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>

        <uix:table name="<%= CubeDimensionUIBean.ATTRIBUTE_UI_TABLE %>"
                   width="90%"
                   minValue="1"
                   tableDataBinding="KeyColumnData@cubeDimBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeDimBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeDimBean@servletRequest"
                   summaryBinding="SEC_HEADER_JOIN_MAP@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_KEY_COLUMN@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_KEY_COLUMN_DIM_TABLE %>"/>
              <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_KEY_COLUMN_DIM_TABLE %>" valueBinding="<%= CubeDimensionUIBean.ATTRIBUTE_KEY_COLUMN_DIM_TABLE %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
               <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_EQUAL %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_FKEY_COLUMN@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:choice name="<%= CubeDimensionUIBean.ATTRIBUTE_KEY_COLUMN_FACT_TABLE %>"
	      selectedValueBinding="KeyColumnFactTable@cubeDimBean@servletRequest" shortDescBinding="COL_HEADER_FKEY_COLUMN@msg">
                <uix:contents childDataBinding="columnData@cubeBean@servletRequest">
                  <uix:option textBinding="textKeyNone@cubeBean@servletRequest" valueBinding="valueKey@cubeBean@servletRequest"/>
                </uix:contents>
              </uix:choice>
            </uix:contents>
          </uix:column>
        </uix:table>
        </uix:header>
        <uix:spacer height="5" width="5"/>
         
        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="BUTTON_CANCEL@msg" name="event" value="<%= Event.DIMENSION_CANCEL.getEventName() %>" shortDescBinding="BUTTON_CANCEL@msg"/><uix:spacer height="1" width="1"/>  
              <uix:submitButton textBinding="BUTTON_OK@msg" name="event" value="<%= Event.DIMENSION_EDIT_OK.getEventName() %>" shortDescBinding="BUTTON_OK@msg"/><uix:spacer height="1" width="5"/>
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


