<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeBean" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/LOV.js"/>   <%-- lovField support --%>
      </uix:metaContainer>

      <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_GENERAL %>"/>
      <uix:pageLayout titleBinding="header@cubeBean@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
        <uix:subTabLayout>
          <%-- property tabs --%>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              <oem:submitLink textBinding="TAB_GENERAL@msg" 
                              shortDescBinding="TAB_GENERAL@msg"
                              formName="pageForm"/>
              <oem:submitLink textBinding="TAB_DIMENSIONS@msg"
                              shortDescBinding="TAB_DIMENSIONS@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.DIMENSION_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/> 
              <oem:submitLink textBinding="TAB_MEASURES@msg"
                              shortDescBinding="TAB_MEASURES@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.MEASURE_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/> 
              <oem:submitLink textBinding="TAB_AGGREGATION@msg"
                              shortDescBinding="TAB_MEASURES@msg"
                              onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.AGGREGATION_PROPERTY.getEventName() + "\'})" %>'
                              formName="pageForm"/>
            </uix:subTabBar>
          </uix:subTabs>

          <%-- start of details section --%>
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_CUBE_NAME@msg" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="cubeName@cubeBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:textInput name="<%= CubeBean.ATTRIBUTE_CUBE_NAME %>" textBinding="cubeName@cubeBean@servletRequest" columns="40" onChange="this.value=this.value.toUpperCase()" shortDescBinding="LABEL_CUBE_NAME@msg"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_DISPLAY_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="<%= CubeBean.ATTRIBUTE_DISPLAY_NAME %>" textBinding="displayName@cubeBean@servletRequest" columns="40" shortDescBinding="LABEL_DISPLAY_NAME@msg"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_SCHEMA@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="schemaName@cubeBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:lovField name="<%= CubeBean.ATTRIBUTE_SCHEMA %>"
                                        shortDescBinding="LABEL_SCHEMA@msg"
                                        searchDescBinding="LABEL_SCHEMA@msg"
                                        columns="40"
                                        textBinding="schemaName@cubeBean@servletRequest"
                                        onClick='<%= "startLov(\'"+CubeBean.ATTRIBUTE_SCHEMA+ "\', \'ListSchemaWithTable\')" %>' />
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_DESCRIPTION@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="<%= CubeBean.ATTRIBUTE_DESCRIPTION %>" textBinding="description@cubeBean@servletRequest" rows="3" wrap="soft" columns="43" shortDescBinding="LABEL_DESCRIPTION@msg"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
             
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:header textBinding="SEC_HEADER_FACT_OBJECT@msg" size="1"/>
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_FACT_TYPE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="factType@cubeBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:choice name="<%= CubeBean.ATTRIBUTE_FACT_TYPE %>"
			  selectedValueBinding="factType@cubeBean@servletRequest" shortDescBinding="LABEL_FACT_TYPE@msg">
                            <uix:contents childDataBinding="factTypeData@cubeBean@servletRequest">
                              <uix:option textBinding="factTypeText@cubeBean@servletRequest" valueBinding="factTypeValue@cubeBean@servletRequest"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_FACT_SCHEMA@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="factSchema@cubeBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:lovField name="<%= CubeBean.ATTRIBUTE_FACT_SCHEMA %>" 
                                        shortDescBinding="LABEL_FACT_SCHEMA@msg"
                                        searchDescBinding="LABEL_FACT_SCHEMA@msg"
                                        columns="40"
                                        textBinding="factSchema@cubeBean@servletRequest"
                                        onClick='<%= "setBindSqlParmFromChoice(\'"+CubeBean.ATTRIBUTE_FACT_TYPE+"\');startLov(\'"+CubeBean.ATTRIBUTE_FACT_SCHEMA+ "\', \'ListFactSchema\')" %>' />
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="LABEL_FACT_TABLE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="factTableName@cubeBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:lovField name="<%= CubeBean.ATTRIBUTE_FACT_TABLE %>" 
                                        shortDescBinding="LABEL_FACT_TABLE@msg"
                                        searchDescBinding="LABEL_FACT_TABLE@msg"
                                        columns="40"
                                        textBinding="factTableName@cubeBean@servletRequest"
                                        onClick='<%= "setBindSqlParmFromChoice(\'"+CubeBean.ATTRIBUTE_FACT_TYPE+"\');setBindSqlParm(\'"+CubeBean.ATTRIBUTE_FACT_SCHEMA+"\');startLov(\'"+CubeBean.ATTRIBUTE_FACT_TABLE+ "\', \'ListFactTable\')" %>' />
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>
       <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
         <uix:case name="false">
          <uix:header textBinding="SEC_HEADER_STATUS@msg" size="1"/>
         </uix:case>
       </uix:switcher>

       <uix:switcher childNameBinding="isAddCube@cubeBean@servletRequest">
         <uix:case name="false">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_STATUS@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                     <uix:styledText styleClass="OraDataText" textBinding="status@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>

               <uix:switcher childNameBinding="statusInvalid@cubeBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="44">
                      <uix:spacer height="1" width="44"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="580">
                      <uix:table name="ViewInvalidityCause"
                                 width="100%"
                                 minValue="1"
                                 tableDataBinding="invalidityCauseData@cubeBean@servletRequest"
                                 formSubmitted="true"
                                 maxValueBinding="invalidityCauseDataLength@cubeBean@servletRequest"
                                 blockSizeBinding="blockSize@cubeBean@servletRequest"
                                 valueBinding="startIndex@cubeBean@servletRequest"
                                 alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

                      <%-- Table column name column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="LABEL_INVALID_CAUSE@msg"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="invalidityCause@cubeBean@servletRequest"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="COL_HEADER_SCHEMA@msg"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="invalidityCauseOwner@cubeBean@servletRequest"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="LABEL_NAME@msg"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="invalidityCauseName@cubeBean@servletRequest"/>
                        </uix:contents>
                      </uix:column>
                    </uix:table>
                   </uix:cellFormat> 
                  </uix:rowLayout>
                 </uix:case>
                </uix:switcher>

                </uix:tableLayout>
              </uix:cellFormat> 
            </uix:rowLayout>
           
          </uix:tableLayout>
         </uix:case>
       </uix:switcher>
          
          <%-- end of details section --%>
        </uix:subTabLayout>

        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


