<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeMeasureUIBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@cubeBean@servletRequest"/>
      <db:script src="/database/utils.js"/>      
    </uix:metaContainer>

    <uix:body>
    <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_MEASURE %>"/>
      <uix:formValue name="<%= CubeMeasureUIBean.ATTRIBUTE_START_INDEX %>" valueBinding="startIndex@cubeMeasureBean@servletRequest" />
    <uix:pageLayout titleBinding="header@cubeBean@servletRequest">

      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
      <uix:subTabLayout>
        <%-- property tabs --%>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="2">
            <oem:submitLink textBinding="TAB_GENERAL@msg" 
                            shortDescBinding="TAB_GENERAL@msg"
                            onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.GENERAL_PROPERTY.getEventName() + "\'})" %>'
                            formName="pageForm"/>
            <oem:submitLink textBinding="TAB_DIMENSIONS@msg"
                            shortDescBinding="TAB_DIMENSIONS@msg"
                            onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.DIMENSION_PROPERTY.getEventName() + "\'})" %>'
                            formName="pageForm"/> 
            <oem:submitLink textBinding="TAB_MEASURES@msg"
                            shortDescBinding="TAB_MEASURES@msg"
                            onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.MEASURE_PROPERTY.getEventName() + "\'})" %>'
                            formName="pageForm"/> 
            <oem:submitLink textBinding="TAB_AGGREGATION@msg"
                            shortDescBinding="TAB_AGGREGATION@msg"
                            onClick='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.AGGREGATION_PROPERTY.getEventName() + "\'})" %>'
                            formName="pageForm"/>
          </uix:subTabBar>
        </uix:subTabs>

        <%-- start of details section --%>
        <uix:spacer height="5" width="5"/>
          <uix:stackLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                <uix:submitButton textBinding="BUTTON_ADD@msg" name="event" value="<%= Event.MEASURE_ADD.getEventName() %>" shortDescBinding="BUTTON_ADD@msg"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>
        <uix:spacer height="5" width="5"/>

        <uix:table name="<%= CubeMeasureUIBean.ATTRIBUTE_UI_TABLE %>"
                   width="100%"
                   minValue="1"
                   tableDataBinding="cubeMeasureData@cubeMeasureBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeMeasureBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeMeasureBean@servletRequest"
                   summaryBinding="TAB_MEASURES@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedIndex@cubeMeasureBean@servletRequest" shortDescBinding="COL_HEADER_SELECT@msg">
              <uix:contents>
              <uix:submitButton textBinding="BUTTON_EDIT@msg" name="event" value="<%= Event.MEASURE_EDIT.getEventName() %>" shortDescBinding="BUTTON_EDIT@msg"/><uix:spacer height="1" width="10"/>  
              <uix:submitButton textBinding="BUTTON_DELETE@msg" name="event" value="<%= Event.MEASURE_DELETE.getEventName() %>" shortDescBinding="BUTTON_DELETE@msg"/>
              </uix:contents>       
            </uix:singleSelection>  
          </uix:tableSelection>

          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_STATE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText styleClass="OraTipText" textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_STATE %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DISPLAY_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DISPLAY_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_SOURCE_NAME@msg"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_COLUMN_NAME %>"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="textFormat"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DATA_TYPE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DATA_TYPE %>"/>
            </uix:contents>
          </uix:column>
      <!-- /uix:singleSelection-->  
        </uix:table>
        <uix:spacer height="15" width="5"/>

        <%-- end of details section --%>
        </uix:subTabLayout>

        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


