<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeMeasureUIBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

      <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_MEASURE_EDIT %>"/>
      <uix:formValue name="<%= CubeMeasureUIBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="selectedIndex@cubeMeasureBean@servletRequest" />
      <uix:formValue name="<%= CubeMeasureUIBean.ATTRIBUTE_STATE %>" valueBinding="stateOfObject@cubeMeasureBean@servletRequest" />
      <uix:formValue name="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DATA_TYPE %>" valueBinding="cubeMeasureDataType@cubeMeasureBean@servletRequest" />
      <uix:pageLayout titleBinding="pageTitle@cubeMeasureBean@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                    
          <%-- start of details section --%>
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="44">
                <uix:spacer height="1" width="44"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="COL_HEADER_MEASURE_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:switcher childNameBinding="isNewMeasure@cubeMeasureBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput name="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>" textBinding="cubeMeasureName@cubeMeasureBean@servletRequest" columns="40" onChange="this.value=this.value.toUpperCase()" shortDescBinding="COL_HEADER_MEASURE_NAME@msg"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="cubeMeasureName@cubeMeasureBean@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="COL_HEADER_DISPLAY_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DISPLAY_NAME %>" textBinding="cubeMeasureDisplayName@cubeMeasureBean@servletRequest" columns="40" shortDescBinding="COL_HEADER_DISPLAY_NAME@msg"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt required="yes" promptBinding="COL_HEADER_SOURCE_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:choice name="<%= CubeMeasureUIBean.ATTRIBUTE_CHOICE_SELECTED %>" selectedValueBinding="cubeMeasureColumnName@cubeMeasureBean@servletRequest" shortDescBinding="COL_HEADER_SOURCE_NAME@msg"
                                   onChange='<%= "submitForm(\'pageForm\', true, {\'event\':\'" + Event.MEASURE_EDIT_ON_CHANGE.getEventName() + "\'})" %>'>
                        <uix:contents childDataBinding="columnData@cubeBean@servletRequest">
                          <uix:option textBinding="textKey@cubeBean@servletRequest" valueBinding="valueKey@cubeBean@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="COL_HEADER_DATA_TYPE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                          <uix:styledText styleClass="OraDataText" textBinding="cubeMeasureDataType@cubeMeasureBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:messagePrompt promptBinding="LABEL_DESCRIPTION@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DESCRIPTION %>" textBinding="cubeMeasureDescription@cubeMeasureBean@servletRequest" rows="3" wrap="soft" columns="43" shortDescBinding="LABEL_DESCRIPTION@msg"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
             
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>
         
        <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="BUTTON_CANCEL@msg" name="event" value="<%= Event.MEASURE_CANCEL.getEventName() %>" shortDescBinding="BUTTON_CANCEL@msg"/><uix:spacer height="1" width="1"/>  
              <uix:submitButton textBinding="BUTTON_OK@msg" name="event" value="<%= Event.MEASURE_EDIT_OK.getEventName() %>" shortDescBinding="BUTTON_OK@msg"/><uix:spacer height="1" width="5"/>
          </uix:pageButtonBar>
        </uix:pageButtons>      
        <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


