<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeBean" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeDimensionUIBean" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeMeasureUIBean" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeAggregationUIBean" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="viewTitle@cubeBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>
      <uix:body>

      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.PAGENAME_CUBE_VIEW %>"/>
      <uix:pageLayout titleBinding="viewHeader@cubeBean@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
                     
          <%-- start of General section --%>
          <uix:header textBinding="TAB_GENERAL@msg" size="1">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat width="24">
                <uix:spacer height="1" width="24"/>
              </uix:cellFormat>
              <uix:cellFormat width="*">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_CUBE_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="cubeName@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_DISPLAY_NAME@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="displayName@cubeBean@servletRequest"/>
                     </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_SCHEMA@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="schemaName@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_DESCRIPTION@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="description@cubeBean@servletRequest"/>
                     </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_FACT_TYPE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="factType@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_FACT_SCHEMA@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="factSchema@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="LABEL_FACT_TABLE@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="factTableName@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText" textBinding="LABEL_STATUS@msg"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                     <uix:styledText styleClass="OraDataText" textBinding="status@cubeBean@servletRequest"/>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
               </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
          <%-- End of General section --%>

          <%-- start of Dimensions section --%>
          <uix:header textBinding="TAB_DIMENSIONS@msg" size="1">
          <uix:table name="ViewDimension"
                     width="100%"
                     minValue="1"
                     tableDataBinding="cubeDimData@cubeDimBean@servletRequest"
                     formSubmitted="true"
                     maxValueBinding="length@cubeDimBean@servletRequest"
                     blockSizeBinding="blockSize@cubeBean@servletRequest"
                     valueBinding="startIndex@cubeDimBean@servletRequest"
                     summaryBinding="TAB_DIMENSIONS@msg"
                     alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">

          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_ALIAS@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_ALIAS %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LABEL_DIMENSION_OWNER@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_SCHEMA %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DIM_OBJECT@msg"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_CUBE_DIM_OBJECT %>"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="textFormat"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DEPENDS_UPON@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeDimensionUIBean.ATTRIBUTE_DEPEND_DIM_NAME %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
        </uix:header>
        <%-- End of Dimensions section --%>

        <%-- start of Measures section --%>
        <uix:header textBinding="TAB_MEASURES@msg" size="1">
        <uix:table name="ViewMeasure"
                   width="100%"
                   minValue="1"
                   tableDataBinding="cubeMeasureData@cubeMeasureBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeMeasureBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeMeasureBean@servletRequest"
                   summaryBinding="TAB_MEASURES@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">
          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DISPLAY_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DISPLAY_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_SOURCE_NAME@msg"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_COLUMN_NAME %>"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="textFormat"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DATA_TYPE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeMeasureUIBean.ATTRIBUTE_CUBE_MEASURE_DATA_TYPE %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
        </uix:header>
         <%-- End of Measures section --%>


        <%-- start of Aggregation section --%>
        <uix:header textBinding="TAB_AGGREGATION@msg" size="1">
        <uix:table name="ViewAggregation"
                   width="100%"
                   minValue="1"
                   tableDataBinding="cubeAggregationData@cubeAggregationBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@cubeAggregationBean@servletRequest"
                   blockSizeBinding="blockSize@cubeBean@servletRequest"
                   valueBinding="startIndex@cubeAggregationBean@servletRequest"
                   summaryBinding="TAB_AGGREGATION@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">
          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_DIMENSION_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_CUBE_DIMENSION_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_OPERATOR@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_OPERATOR_SELECTED %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_ARGUMENT_COLUMN@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= CubeAggregationUIBean.ATTRIBUTE_ARGUMENT_COLUMN_SELECTED %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
        </uix:header>
         <%-- End of Aggregation section --%>
          
      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
          <uix:ref refID="pageButtonViewInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  
      
      </uix:pageLayout>  
      </db:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>


