<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.cube.Event" %>
<%@ page import="oracle.sysman.emo.adm.olap.cube.CubeDimensionUIBean" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.CubeMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

      <uix:body>
      <db:form name="pageForm" method="post" destination="/console/database/olap/cube"
               copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= Event.DIMENSION_DELETE.getPageName() %>"/>
      <uix:formValue name="<%= CubeDimensionUIBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="selectedIndex@cubeDimBean@servletRequest" />
      <uix:pageLayout titleBinding="SEC_HEADER_DELETE_DIMENSION@msg">

        <%@ include file="/database/global.jspf" %>

          <uix:header textBinding="MESSAGE_TYPE_CONFIRMATION@msg" messageType="confirmation">

            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="left">
                <uix:cellFormat width="44">
                  <uix:spacer height="1" width="44"/>
                </uix:cellFormat>
            
                <uix:cellFormat width="*">
                  <uix:styledText styleClass="OraDataText" textBinding="MSG_DELETE_CONFIRMATION_DIMENSION_BODY@msg" />  
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                  <uix:spacer height="60" width="44" />
                </uix:cellFormat>
            
                <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="deleteDimension@cubeDimBean@servletRequest" />  
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Tip --%>
              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                  <uix:spacer height="60" width="44" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:tip>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="MSG_TEXT_CONFIRM_TIP@msg" />
                  </uix:tip>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="BUTTON_NO@msg" destination="javascript: history.back()" shortDescBinding="BUTTON_NO@msg"/>
              <uix:submitButton textBinding="BUTTON_YES@msg" name="event" value="<%= Event.DIMENSION_DELETE_EXEC.getEventName() %>" shortDescBinding="BUTTON_YES@msg"/>
             </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            

     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
