<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.olap.dimension.DimensionBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.DimensionMsg" />
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="title@cubeBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" valueBinding="confirmPageName@dimensionBean@servletRequest" />
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="itemIndex@dimensionBean@servletRequest" />
    <uix:contents>
    
    <uix:pageLayout titleBinding="pageTitle@dimensionBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

          <uix:header textBinding="MESSAGE_TYPE_CONFIRMATION@msg" messageType="confirmation">

            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="left">
                <uix:cellFormat width="44">
                  <uix:spacer height="1" width="44"/>
                </uix:cellFormat>
            
                <uix:cellFormat width="*">
                  <uix:styledText styleClass="OraDataText" textBinding="confirmBodyMessage@dimensionBean@servletRequest" />  
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                  <uix:spacer height="60" width="44" />
                </uix:cellFormat>
            
                <uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="confirmDeleteMessage@dimensionBean@servletRequest" />  
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Tip --%>
              <uix:rowLayout hAlign="left">
                <uix:cellFormat>
                  <uix:spacer height="60" width="44" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:tip>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="MSG_TEXT_CONFIRM_TIP@msg" />
                  </uix:tip>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="BUTTON_NO@msg" destination="javascript: history.back()" />
              <uix:submitButton textBinding="BUTTON_YES@msg" name="event" valueBinding="eventName@dimensionBean@servletRequest" />
             </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            
      </uix:contents>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
