<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_ADD_HIER@dimensionBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimAddHierarchy"/>
    <uix:contents>
    <uix:pageLayout titleBinding="ADD_HIER@dimensionBundle@servletRequest">
    
    <%@ include file="/database/global.jspf" %>
    
      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="24">
          <uix:spacer height="1" width="24"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" labeledNodeId="NAME"
                                     required="yes"/>
                </uix:cellFormat>
                <uix:textInput name="newHier" textBinding="newHier@dimensionBean@servletRequest" id="NAME" shortDescBinding="NAME@uixDBObjectBundle@servletRequest" onBlur="this.value=this.value.toUpperCase()" />
              </uix:rowLayout>
              </uix:tableLayout>
            
        <uix:spacer height="15" width="5"/>
          <oem:shuttle name="Levels" 
                       leadingHeaderBinding="AVAILABLE_LEVELS@dimensionBundle@servletRequest"
                       trailingHeaderBinding="SELECTED_LEVELS@dimensionBundle@servletRequest"
                       size="10" reorderable="true">
            <uix:leading>
              <oem:list name="availLevels" multiple="true" selectedIndex="0" shortDescBinding="AVAILABLE_LEVELS@dimensionBundle@servletRequest"
                        optionsBinding="availLevels@dimHierarchiesUIBean@servletRequest"/> 
            </uix:leading>
            <uix:trailing>
              <oem:list name="selLevels" multiple="true" selectedIndex="0" shortDescBinding="SELECTED_LEVELS@dimensionBundle@servletRequest"
                        optionsBinding="selLevels@dimHierarchiesUIBean@servletRequest"/>
            </uix:trailing>
          </oem:shuttle>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                            name="event" value="returnToHierarchiesTab"/>
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                            name="event" value="apply"/>
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%> 
      
    </uix:pageLayout>
    </uix:contents>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
