<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_MODIFY_JKS@dimensionBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimAddJoinKeys"/>
    <uix:contents>
    <uix:pageLayout titleBinding="MODIFY_JKS@dimensionBundle@servletRequest">
    
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:tableLayout cellSpacing="5"  width="100%">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="14">
          <uix:spacer height="1" width="14"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
      <uix:tableLayout cellSpacing="5">
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText" labeledNodeId="levelPair"
                            textBinding="LEVEL_PAIR@dimensionBundle@servletRequest"/>
          </uix:cellFormat>
         <oem:choice name="selLevelPair" optionsBinding="levelPairs@dimensionBean@servletRequest" id="levelPair"
                      selectedValueBinding="selLevelPair@dimensionBean@servletRequest"
                      onChange='<%= "submitForm(\'pageForm\', true, {\'event\':\'displayJoins\'})" %>' />
        </uix:rowLayout>   
     </uix:tableLayout>
     <uix:spacer height="15" width="5"/>

    <%-- start of table of join columns for the selectedparent/child pair --%>
      <uix:tableLayout width="100%">
        <uix:rowLayout>                                  
          <oem:table name="dimJoinKeysUI" beanKey="dimJoinKeysUIBean"
                     destination="/em/console/database/olap/dimension"
                     formSubmitted="true" blockSize="10" width="100%"
                     dataSourceProp="dimJoinKeysUI" 
                     summaryBinding="MODIFY_JKS@dimensionBundle@servletRequest"
                     alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>
        </uix:rowLayout>
      </uix:tableLayout> 
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>

    <%-- end of table --%>      
        
      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                            name="event" value="returnToJoinKeysTab"/>
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                            name="event" value="apply"/>
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  
    
    </uix:pageLayout>
    </uix:contents>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
