<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.emo.adm.olap.dimension.DimensionBean" %>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_ADD_LEVEL@dimensionBundle@servletRequest"/>
      <db:script src="/database/utils.js"/>            
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimAddLevel"/>
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="itemIndex@dimensionBean@servletRequest" />
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_STATE %>" valueBinding="stateString@dimensionBean@servletRequest" />
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_PAGE_TITLE %>" valueBinding="pageTitle@dimensionBean@servletRequest" />
    <uix:formValue name="schemaName" valueBinding="schemaName@dimensionBean@servletRequest" />
    <uix:contents>
    
    <uix:pageLayout titleBinding="pageTitle@dimensionBean@servletRequest">
    
    <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="24">
          <uix:spacer height="1" width="24"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"
                                   required="yes"/>
              </uix:cellFormat>
                <uix:switcher childNameBinding="isNewItem@dimensionBean@servletRequest">
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText" textBinding="newLevel@dimensionBean@servletRequest"/>
                  </uix:case>
                  <uix:case name="true">
                    <uix:textInput name="newLevel" textBinding="newLevel@dimensionBean@servletRequest" onChange="this.value=this.value.toUpperCase()" columns="35" shortDescBinding="NAME@uixDBObjectBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>

        <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
          <uix:case name="true">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="TYPE@uixDBObjectBundle@servletRequest" labeledNodeId="TYPE"/>
              </uix:cellFormat>
              <uix:choice name="<%= DimensionBean.ATTRIBUTE_LEVEL_TYPE %>" selectedValueBinding="selLevelType@dimensionBean@servletRequest" id="TYPE">
                <uix:contents childDataBinding="levelTypes@dimensionBean@servletRequest">
                  <uix:option textBinding="attrTypesText@dimensionBean@servletRequest" valueBinding="attrTypesValue@dimensionBean@servletRequest"/>
                </uix:contents>
              </uix:choice>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>        

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="SCHEMA_TABLE_LABEL@dbMsgs"
                                   required="yes"/>              
              </uix:cellFormat>
                <uix:switcher childNameBinding="isNewItem@dimensionBean@servletRequest">
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText" textBinding="tableName@dimensionBean@servletRequest" />
                  </uix:case>
                  <uix:case name="true">
                   <uix:lovField name="<%= DimensionBean.ATTRIBUTE_TABLE_NAME %>" 
                                 id="TABLE" shortDescBinding="TABLE@uixDBObjectBundle@servletRequest"
                                 columns="35"
                                 searchDescBinding="SCHEMA_TABLE_LABEL@dbMsgs"
                                 textBinding="selLevelTable@dimensionBean@servletRequest"
                                 onClick='<%= "setSearchFilter(\'schemaName\');startLov(\'"+DimensionBean.ATTRIBUTE_TABLE_NAME+ "\', \'ListSchemaTable\')" %>' />
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="isNewItem@dimensionBean@servletRequest">
                  <uix:case name="true">
                     <uix:submitButton textBinding="POPULATE_COLUMNS@dimensionBundle@servletRequest" name="event" value="displayColumnsForTable"/>
                  </uix:case>
                </uix:switcher>
            </uix:rowLayout>            
          </uix:tableLayout>
          <uix:spacer height="15" width="5"/>
          <uix:tableLayout cellSpacing="5"> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                <uix:switcher childNameBinding="isNewItem@dimensionBean@servletRequest">
                  <uix:case name="false">
                    <uix:messagePrompt promptBinding="SELECTED_COLUMNS@uixDBObjectBundle@servletRequest" />
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>            
          </uix:tableLayout>
          
      <uix:switcher childNameBinding="isNewItem@dimensionBean@servletRequest">
        <uix:case name="false">
          <oem:list name="selTableColumns" multiple="false" optionsBinding="selTableColumns@dimensionBean@servletRequest" size="10" shortDescBinding="SELECTED_COLUMNS@uixDBObjectBundle@servletRequest" />
        </uix:case>
        <uix:case name="true">
          <oem:shuttle name="Columns" 
                       leadingHeaderBinding="AVAILABLE_COLUMNS@dimensionBundle@servletRequest"
                       trailingHeaderBinding="SELECTED_COLUMNS@dimensionBundle@servletRequest"
                       size="10" reorderable="false">
            <uix:leading>
              <oem:list name="availTableColumns" multiple="true" shortDescBinding="AVAILABLE_COLUMNS@dimensionBundle@servletRequest"
                        optionsBinding="availTableColumns@dimensionBean@servletRequest"/>
            </uix:leading>
            <uix:trailing>
              <oem:list name="selTableColumns" multiple="true" shortDescBinding="SELECTED_COLUMNS@dimensionBundle@servletRequest"
                        optionsBinding="selTableColumns@dimensionBean@servletRequest"/>
            </uix:trailing>
          </oem:shuttle>
        </uix:case>
      </uix:switcher>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            name="event" value="returnToLevelsTab"/>
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="OK@uixDBObjectBundle@servletRequest" 
                            name="event" value="apply"/>
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%> 

    </uix:pageLayout>
    </uix:contents>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
