<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<%@ page import="oracle.sysman.emo.adm.olap.dimension.DimensionBean" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_ADD_ATTR@dimensionBundle@servletRequest"/>
       <db:script src="/database/utils.js"/>      
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimNonOlapAddAttribute"/>
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_SELECTED_INDEX %>" valueBinding="itemIndex@dimensionBean@servletRequest" />
    <uix:formValue name="<%= DimensionBean.ATTRIBUTE_START_INDEX %>" valueBinding="startIndex@dimensionBean@servletRequest" />
    <uix:contents>
    <uix:pageLayout titleBinding="pageTitle@dimensionBean@servletRequest">

    <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="24">
          <uix:spacer height="1" width="24"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="LEVEL@dimensionBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:switcher childNameBinding="newAttribute@dimensionBean@servletRequest">
                <uix:case name="true">
                  <uix:choice name="levelName" selectedValueBinding="currentLevelName@dimensionBean@servletRequest" shortDescBinding="LEVEL@dimensionBundle@servletRequest"
                              onChange="submitForm('dimensionForm', true, {'event':'setNewLevel'})">
                    <uix:contents childDataBinding="newLevelAttribute@dimensionBean@servletRequest">
                      <uix:option textBinding="newLevelNameText@dimensionBean@servletRequest" valueBinding="newLevelNameValue@dimensionBean@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:case>
                <uix:case name="false">
                  <uix:styledText styleClass="OraDataText" textBinding="currentLevelName@dimensionBean@servletRequest"/>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>


        <uix:header textBinding="AVAILABLE_ATTRIBUTES@dimensionBundle@servletRequest" size="1">          
           
        <uix:tableLayout width="100%">
        <uix:rowLayout> 

        <uix:table name="selAttrLevels"
                   width="100%"
                   minValue="1"
                   tableDataBinding="levelAttributes@dimensionBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@dimensionBean@servletRequest"
                   blockSize="<%= DimensionBean.blockSize %>"
                   valueBinding="startIndex@dimensionBean@servletRequest"
                   summaryBinding="AVAILABLE_ATTRIBUTES@dimensionBundle@servletRequest"
                   alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
          <uix:tableSelection>
            <uix:multipleSelection selectedBinding="selectedLevelAttributeName@dimensionBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"/>
          </uix:tableSelection>
          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LEVEL_ATTRIBUTE@dimensionBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="levelAttributeName@dimensionBean@servletRequest"/>
            </uix:contents>
          </uix:column>
        </uix:table>
             
           </uix:rowLayout>
         </uix:tableLayout>
      </uix:header>
         <%-- end of table --%>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAttribute" />
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="saveLevelAttribute"/>
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%> 

    </uix:pageLayout>
    </uix:contents>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
