<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    
    <uix:metaContainer>
      <uix:head titleBinding="title@dimensionBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimensionAttributes"/>
    <uix:pageLayout titleBinding="header@dimensionBean@servletRequest">

    <uix:formValue name="selLevelList" value="undefined"/>
    <uix:formValue name="availLevelList" value="undefined"/>    
    
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:subTabLayout>

      <%-- property tabs --%>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="3">
          <oem:submitLink textBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          shortDescBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'generalTab'})"                
                          formName="dimensionForm"/>
          <oem:submitLink textBinding="LEVELS@dimensionBundle@servletRequest"
                          shortDescBinding="LEVELS@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'levelsTab'})"
                          formName="dimensionForm"/> 
          <oem:submitLink textBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          shortDescBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'hierarchiesTab'})"          
                          formName="dimensionForm"/> 
          <oem:submitLink textBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                          shortDescBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'attributesTab'})"
                          formName="dimensionForm"/>
          <%-- only need if OLAP option is installed --%>
          <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
            <uix:case name="true">
              <oem:submitLink textBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              shortDescBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              onClick="submitForm('dimensionForm', true, {event:'olapOptionsTab'})"
                              formName="dimensionForm"/>
            </uix:case>
          </uix:switcher>
          <%-- only need join keys tab if dimension has them --%>  
          <uix:switcher childNameBinding="hasJoinKeys@dimensionBean@servletRequest">
            <uix:case name="true">
              <oem:submitLink textBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              shortDescBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              onClick="submitForm('dimensionForm', true, {event:'joinKeysTab'})"
                              formName="dimensionForm"/>
             </uix:case>
           </uix:switcher>
         </uix:subTabBar>
       </uix:subTabs>

       <%-- start table of attribute names and types --%>
       <uix:tableLayout width="100%">
         <uix:rowLayout hAlign="right">
           <uix:cellFormat>
             <uix:contents>
               <uix:submitButton textBinding="ADD@uixDBObjectBundle@servletRequest"
                                 name="event" value="addAttribute"/>                  
             </uix:contents>
           </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>                                  
           <oem:table name="dimAttributesUI" beanKey="dimAttributesUIBean"
                      destination="/console/database/olap/dimension" 
                      formSubmitted="true" blockSize="10"
                      dataSourceProp="dimAttributesUI"
                      alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                      summaryBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                      width="100%">
             <uix:tableSelection> 
               <uix:singleSelection selectedIndexBinding="selectedIndex@dimAttributesUIBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest">                              
                 <uix:submitButton textBinding="DELETE@uixDBObjectBundle@servletRequest" 
                                   name="event" value="deleteAttribute"/>
                 <uix:spacer height="1" width="5"/>
                 <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                                   name="event" value="editAttribute"/>
               </uix:singleSelection>
             </uix:tableSelection> 
           </oem:table>
         </uix:rowLayout>
       </uix:tableLayout>
       <%-- end of table --%>

      </uix:subTabLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>   
      
    </uix:pageLayout>      
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
