<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<script language="javascript">
function callBackLov()
{
}
</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@dimensionBean@servletRequest"/>
      <db:script src="/database/LOV.js"/>      
    </uix:metaContainer>

    <uix:body>
    <db:form name="dbObjectsList" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimensionGeneral"/>
    <uix:pageLayout titleBinding="header@dimensionBean@servletRequest">

    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
    <uix:subTabLayout>

      <%-- property tabs --%>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="0">
          <oem:submitLink textBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          shortDescBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          onClick="submitForm('dbObjectsList', true, {event:'generalTab'})"
                          formName="dbObjectsList"/>
          <oem:submitLink textBinding="LEVELS@dimensionBundle@servletRequest"
                          shortDescBinding="LEVELS@dimensionBundle@servletRequest"
                          onClick="submitForm('dbObjectsList', true, {'event':'levelsTab'})"
                          formName="dbObjectsList"/> 
          <oem:submitLink textBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          shortDescBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          onClick="submitForm('dbObjectsList', true, {'event':'hierarchiesTab'})"
                          formName="dbObjectsList"/> 
          <oem:submitLink textBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                          shortDescBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                          onClick="submitForm('dbObjectsList', true, {'event':'attributesTab'})"
                          formName="dbObjectsList"/>
          <%-- only need if OLAP option is installed --%>        
          <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
            <uix:case name="true">
              <oem:submitLink textBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              shortDescBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              onClick="submitForm('dbObjectsList', true, {'event':'olapOptionsTab'})"
                              formName="dbObjectsList"/>
            </uix:case>
          </uix:switcher>        
          <%-- only need join keys tab if dimension has them --%>
          <uix:switcher childNameBinding="hasJoinKeys@dimensionBean@servletRequest">
            <uix:case name="true">
              <oem:submitLink textBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              shortDescBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              onClick="submitForm('dbObjectsList', true, {'event':'joinKeysTab'})"
                              formName="dbObjectsList"/>                              
            </uix:case>
          </uix:switcher>
        </uix:subTabBar>
      </uix:subTabs>

      <%-- start of details section --%>
      <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="44">
          <uix:spacer height="1" width="44"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
          <%-- djk - required didn't seem to work if in same switcher as input field --%>
            <uix:switcher childNameBinding="creating@dimensionBean@servletRequest">        
              <uix:case name="true">           
                <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" 
                                   required="yes"/>
              </uix:case>                     
              <uix:case name="false">           
                <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
              </uix:case> 
            </uix:switcher>
          </uix:cellFormat> 
          <uix:switcher childNameBinding="creating@dimensionBean@servletRequest">
            <uix:case name="true">
              <uix:textInput name="dimName" 
                             textBinding="dimName@dimensionBean@servletRequest" onChange="this.value=this.value.toUpperCase()" columns="30" shortDescBinding="NAME@uixDBObjectBundle@servletRequest"/>            
            </uix:case>
            <uix:case name="false">
              <uix:styledText styleClass="OraDataText"
                              textBinding="dimName@dimensionBean@servletRequest"/>                 
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:switcher childNameBinding="creating@dimensionBean@servletRequest">        
              <uix:case name="true">           
                <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest" labeledNodeId="SCHEMA"
                                   required="yes"/>
              </uix:case>                     
              <uix:case name="false">           
                <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
              </uix:case> 
            </uix:switcher>
          </uix:cellFormat>         
          <uix:switcher childNameBinding="creating@dimensionBean@servletRequest">
            <uix:case name="true">
              <uix:lovField name="schemaName" 
                            shortDescBinding="SCHEMA@uixDBObjectBundle@servletRequest" id="SCHEMA"
                            columns="30"
                            textBinding="schemaName@dimensionBean@servletRequest"
                            searchDescBinding="SCHEMA@uixDBObjectBundle@servletRequest"
                            onClick="startLov('schemaName', 'ListSchema');"/>
            </uix:case>
            <uix:case name="false">          
              <uix:styledText styleClass="OraDataText"
                              textBinding="schemaName@dimensionBean@servletRequest"/>
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>

        <%-- no need to display status when creating a dimension --%>
        <uix:switcher childNameBinding="creating@dimensionBean@servletRequest">
          <uix:case name="false">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="STATUS@uixDBObjectBundle@servletRequest"/>            
              </uix:cellFormat>
              <uix:switcher childNameBinding="valid@dimensionBean@servletRequest">
                <uix:case name="true">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="VALID@dimensionBundle@servletRequest"/>
                </uix:case>
                <uix:case name="false">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="NOT_VALID@dimensionBundle@servletRequest"/>
                </uix:case>
              </uix:switcher>                     
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
          <uix:case name="true">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="TYPE@uixDBObjectBundle@servletRequest"/>            
              </uix:cellFormat>
                <uix:switcher childNameBinding="dimType@dimensionBean@servletRequest">
                  <uix:case name="0">
                    <uix:flowLayout>
                      <uix:radioButton name="dimType" selected="true" value="0"
                                       textBinding="NORMAL@dimensionBundle@servletRequest"/> 
                      <uix:radioButton name="dimType" selected="false" value="1"
                                       textBinding="TIME@dimensionBundle@servletRequest"/>
                    </uix:flowLayout>      
                  </uix:case>
                  <uix:case name="1">
                    <uix:flowLayout>
                      <uix:radioButton name="dimType" selected="false" value="0"
                                       textBinding="NORMAL@dimensionBundle@servletRequest"/> 
                      <uix:radioButton name="dimType" selected="true" value="1"
                                       textBinding="TIME@dimensionBundle@servletRequest"/>
                    </uix:flowLayout>      
                  </uix:case>
                  <uix:case name="-1"> <%-- for creating (validity hasn't been set yet) --%>
                    <uix:flowLayout>
                      <uix:radioButton name="dimType" selected="true" value="0"
                                       textBinding="NORMAL@dimensionBundle@servletRequest"/>
                      <uix:radioButton name="dimType" selected="false" value="1"
                                       textBinding="TIME@dimensionBundle@servletRequest"/>
                      </uix:flowLayout>      
                  </uix:case> 
                </uix:switcher>    
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
        </uix:tableLayout>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>
        <%-- end of details section --%>

      </uix:subTabLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  
      
     </uix:pageLayout>  
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


