<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@dimensionBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimensionOLAPOptions"/>
    <uix:pageLayout titleBinding="header@dimensionBean@servletRequest">

    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:subTabLayout>

      <%-- property tabs --%>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="4">
          <oem:submitLink textBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          shortDescBinding="GENERAL@uixDBObjectBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'generalTab'})"
                          formName="dimensionForm"/> 
          <oem:submitLink textBinding="LEVELS@dimensionBundle@servletRequest"
                          shortDescBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'levelsTab'})"
                          formName="dimensionForm"/> 
          <oem:submitLink textBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          shortDescBinding="HIERARCHIES@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'hierarchiesTab'})"
                          formName="dimensionForm"/> 
          <oem:submitLink textBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                          shortDescBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                          onClick="submitForm('dimensionForm', true, {event:'attributesTab'})"
                          formName="dimensionForm"/> 
          <%-- only need if OLAP option is installed --%>
          <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
            <uix:case name = "true">
              <oem:submitLink textBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              shortDescBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                              onClick="submitForm('dimensionForm', true, {'event':'olapOptionsTab'})"
                              formName="dimensionForm"/> 
            </uix:case>
          </uix:switcher>
          <%-- only need join keys tab if hierarchy has them --%>  
          <uix:switcher childNameBinding="hasJoinKeys@dimensionBean@servletRequest">
            <uix:case name="true"> 
              <oem:submitLink textBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              shortDescBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                              onClick="submitForm('dimensionForm', true, {event:'joinKeysTab'})"
                              formName="dimensionForm"/>                             
            </uix:case>
          </uix:switcher>
        </uix:subTabBar>
      </uix:subTabs>

      <%-- start dimension's OLAP option details section --%>
      <uix:tableLayout cellSpacing="5"> 
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="24">
          <uix:spacer height="1" width="24"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="PLURAL_NAME@dimensionBundle@servletRequest" labeledNodeId="PLURAL_NAME"/>
          </uix:cellFormat>
          <uix:textInput name="pluralName" 
                         textBinding="pluralName@dimensionBean@servletRequest" columns="48" id="PLURAL_NAME"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="DEF_DISP_HIER@dimensionBundle@servletRequest" labeledNodeId="DEF_DISP_HIER"/>
          </uix:cellFormat>
            <uix:switcher childNameBinding="hasHiers@dimHierarchiesUIBean@servletRequest">
              <uix:case name="true">
                <uix:choice name="defaultDisplayHierarchy" selectedValueBinding="defaultDisplayHierarchy@dimensionBean@servletRequest" id="DEF_DISP_HIER">
                  <uix:contents childDataBinding="dimHiers@dimHierarchiesUIBean@servletRequest">
                      <uix:option textBinding="textDimHier@dimHierarchiesUIBean@servletRequest" valueBinding="valueDimHier@dimHierarchiesUIBean@servletRequest"/>
                  </uix:contents>
                </uix:choice>
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:switcher childNameBinding="isDBVersion10@dimensionBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraPromptText" textBinding="ATTRIBUTE_SHORT_DESCRIPTION@dimensionBundle@servletRequest" labeledNodeId="DISP_NAME"/>
              </uix:case>
              <uix:case name="false">
                <uix:styledText styleClass="OraPromptText" textBinding="DISP_NAME@dimensionBundle@servletRequest" labeledNodeId="DISP_NAME"/>
              </uix:case>
           </uix:switcher>        
          </uix:cellFormat>
          <uix:textInput name="displayName" 
                         textBinding="displayName@dimensionBean@servletRequest" columns="48" id="DISP_NAME"/>
        </uix:rowLayout>
              
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:switcher childNameBinding="isDBVersion10@dimensionBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraPromptText" textBinding="ATTRIBUTE_LONG_DESCRIPTION@dimensionBundle@servletRequest" labeledNodeId="DESCRIPTION"/>
              </uix:case>
              <uix:case name="false">
                <uix:styledText styleClass="OraPromptText" textBinding="DESCRIPTION@uixDBObjectBundle@servletRequest" labeledNodeId="DESCRIPTION"/>
              </uix:case>
            </uix:switcher>        
          </uix:cellFormat>
             <uix:textInput name="description"
                            textBinding="description@dimensionBean@servletRequest" rows="3" wrap="soft" columns="50" id="DESCRIPTION"/>
        </uix:rowLayout>
                           
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
             <uix:styledText styleClass="OraPromptText"
                             textBinding="PRIMARY_ORDER@dimensionBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:switcher childNameBinding="primaryDisplaySortOrder@dimensionBean@servletRequest">
            <uix:case name="13">
              <uix:flowLayout>
                <uix:radioButton name="primaryDisplaySortOrder" selected="true" value="13"
                                 textBinding="HIERARCHICAL@dimensionBundle@servletRequest"/> 
                <uix:radioButton name="primaryDisplaySortOrder" selected="false" value="14"
                                 textBinding="LEVEL@dimensionBundle@servletRequest"/>
              </uix:flowLayout>      
            </uix:case>
            <uix:case name="14">
              <uix:flowLayout>
                <uix:radioButton name="primaryDisplaySortOrder" selected="false" value="13"
                                 textBinding="HIERARCHICAL@dimensionBundle@servletRequest"/>
                <uix:radioButton name="primaryDisplaySortOrder" selected="true" value="14"
                                 textBinding="LEVEL@dimensionBundle@servletRequest"/>
              </uix:flowLayout> 
            </uix:case>
            <uix:case name="-1"> <%-- on create --%>
              <uix:flowLayout>
                <uix:radioButton name="primaryDisplaySortOrder" selected="true" value="13"
                                 textBinding="HIERARCHICAL@dimensionBundle@servletRequest"/> 
                <uix:radioButton name="primaryDisplaySortOrder" selected="false" value="14"
                                 textBinding="LEVEL@dimensionBundle@servletRequest"/>
              </uix:flowLayout>      
            </uix:case>            
          </uix:switcher>    
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="SECONDARY_ORDER@dimensionBundle@servletRequest"/>
          </uix:cellFormat>
             <uix:switcher childNameBinding="secondaryDisplaySortOrder@dimensionBean@servletRequest">
               <uix:case name="15">
                 <uix:flowLayout>
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="true" value="15"
                                    textBinding="ASCENDING@dimensionBundle@servletRequest"/> 
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="false" value="16"
                                    textBinding="DESCENDING@dimensionBundle@servletRequest"/>
                 </uix:flowLayout>      
               </uix:case>
               <uix:case name="16">
                 <uix:flowLayout>
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="false" value="15"
                                    textBinding="ASCENDING@dimensionBundle@servletRequest"/> 
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="true" value="16"
                                    textBinding="DESCENDING@dimensionBundle@servletRequest"/>
                 </uix:flowLayout>      
               </uix:case>
               <uix:case name="-1"> <%-- on create --%>
                 <uix:flowLayout>
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="true" value="15"
                                    textBinding="ASCENDING@dimensionBundle@servletRequest"/> 
                   <uix:radioButton name="secondaryDisplaySortOrder" selected="false" value="16"
                                    textBinding="DESCENDING@dimensionBundle@servletRequest"/>
                 </uix:flowLayout>      
               </uix:case>               
             </uix:switcher>    
           </uix:rowLayout>
         </uix:tableLayout>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>
         <%-- end of details section --%>

         <%-- start of table of options --%>
         <uix:header textBinding="DISP_NAME_DESC@dimensionBundle@servletRequest" size="1">          
           
         <uix:tableLayout width="100%">
           <uix:rowLayout>                                  
             <oem:table name="dimOLAPOptionsUI" beanKey="dimOLAPOptionsUIBean"
                        destination="/console/database/olap/dimension" formSubmitted="true"
                        blockSize="10" dataSourceProp="dimOLAPOptionsUI"
                        alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                        summaryBinding="DISP_NAME_DESC@dimensionBundle@servletRequest"
                        width="100%" />
           </uix:rowLayout>
         </uix:tableLayout>
         </uix:header>
         <%-- end of table --%>

      </uix:subTabLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  

    </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
