<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.emo.adm.olap.dimension.DimensionBean" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="viewTitle@dimensionBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="dimensionForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="/database/olap/dimension/dimensionView"/>
    <uix:pageLayout titleBinding="viewHeader@dimensionBean@servletRequest">

    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:subTabLayout>
    
      <%-- start of details section --%>
      <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest" size="1">          
      
        <%-- only display these if instance has OLAP option installed --%>
        <%-- seems to be a bug with switchers and tableLayout, so some rowLayouts repeated --%>
       <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
         <uix:case name="true">
           <uix:tableLayout cellSpacing="5">
             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="NAME@uixDBObjectBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:styledText styleClass="OraDataText"
                               textBinding="dimName@dimensionBean@servletRequest"/>                 
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>            
               </uix:cellFormat>
               <uix:styledText styleClass="OraDataText"
                                textBinding="schemaName@dimensionBean@servletRequest"/>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="STATUS@uixDBObjectBundle@servletRequest"/>            
               </uix:cellFormat>
               <uix:switcher childNameBinding="valid@dimensionBean@servletRequest">
                 <uix:case name="true">
                   <uix:styledText styleClass="OraDataText" 
                                   textBinding="VALID@dimensionBundle@servletRequest"/>
                 </uix:case>
                 <uix:case name="false">
                   <uix:styledText styleClass="OraDataText" 
                                   textBinding="NOT_VALID@dimensionBundle@servletRequest"/>
                 </uix:case>
               </uix:switcher>                     
             </uix:rowLayout>
        
             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="TYPE@uixDBObjectBundle@servletRequest"/>            
               </uix:cellFormat>
                 <uix:switcher childNameBinding="dimType@dimensionBean@servletRequest">
                   <uix:case name="0">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="NORMAL@dimensionBundle@servletRequest"/>
                   </uix:case>
                   <uix:case name="1">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="TIME@dimensionBundle@servletRequest"/>
                   </uix:case>                   
                 </uix:switcher> 
               </uix:rowLayout>

               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="PLURAL_NAME@dimensionBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="pluralName@dimensionBean@servletRequest"/>
               </uix:rowLayout>

               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="DEF_DISP_HIER@dimensionBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:styledText styleClass="OraDataText"
                                textBinding="defaultDisplayHierarchy@dimensionBean@servletRequest"/>
               </uix:rowLayout>

               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="DISP_NAME@dimensionBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="displayName@dimensionBean@servletRequest"/>
               </uix:rowLayout> 

               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="DESCRIPTION@uixDBObjectBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="description@dimensionBean@servletRequest"/>
               </uix:rowLayout>  
                                  
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="PRIMARY_ORDER@dimensionBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:switcher childNameBinding="primaryDisplaySortOrder@dimensionBean@servletRequest">
                   <uix:case name="13">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="HIERARCHICAL@dimensionBundle@servletRequest"/>
                   </uix:case>
                   <uix:case name="14">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="LEVEL@dimensionBundle@servletRequest"/>
                   </uix:case>
                 </uix:switcher>    
               </uix:rowLayout>                  

               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="SECONDARY_ORDER@dimensionBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:switcher childNameBinding="secondaryDisplaySortOrder@dimensionBean@servletRequest">
                   <uix:case name="15">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="ASCENDING@dimensionBundle@servletRequest"/>
                   </uix:case>
                   <uix:case name="16">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="DESCENDING@dimensionBundle@servletRequest"/>
                   </uix:case>
                 </uix:switcher>    
               </uix:rowLayout>    
             </uix:tableLayout>
           </uix:case>
           <uix:case name="false">
             <uix:tableLayout cellSpacing="5">
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="NAME@uixDBObjectBundle@servletRequest"/>
                 </uix:cellFormat>
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="dimName@dimensionBean@servletRequest"/>                 
              </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>            
               </uix:cellFormat>
               <uix:styledText styleClass="OraDataText"
                               textBinding="schemaName@dimensionBean@servletRequest"/>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                                 textBinding="STATUS@uixDBObjectBundle@servletRequest"/>            
               </uix:cellFormat>
               <uix:switcher childNameBinding="valid@dimensionBean@servletRequest">
                 <uix:case name="true">
                   <uix:styledText styleClass="OraDataText" 
                                   textBinding="VALID@dimensionBundle@servletRequest"/>
                 </uix:case>
                 <uix:case name="false">
                   <uix:styledText styleClass="OraDataText" 
                                   textBinding="NOT_VALID@dimensionBundle@servletRequest"/>
                 </uix:case>
               </uix:switcher>                     
            </uix:rowLayout>
            </uix:tableLayout> 
          </uix:case>
        </uix:switcher> 
       </uix:header>
        <%-- end of details section --%>

        <%-- start of levels section --%>
        <uix:header textBinding="LEVELS@dimensionBundle@servletRequest" size="1">
        
        <uix:tableLayout width="99%"> 
          <uix:rowLayout>
            <oem:table name="dimLevelsUI" beanKey="dimLevelsUIBean"
                       destination="/console/database/olap/dimension" 
                       formSubmitted="true"
                       dataSourceProp="dimLevelsUI"
                       blockSize="10" 
                       width="100%"
                       summaryBinding="LEVELS@dimensionBundle@servletRequest"
                       alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>                       
          </uix:rowLayout>
        </uix:tableLayout>
        </uix:header>
        <%-- end of levels sections --%>

        <%-- start of hierarchies section --%>
        <uix:header textBinding="HIERARCHIES@dimensionBundle@servletRequest" size="1">
        
        <uix:tableLayout width="99%">
          <uix:rowLayout>                                  
            <oem:table name="dimHierLevelsUI" beanKey="dimHierLevelsUIBean"
                       destination="/console/database/olap/dimension" 
                       formSubmitted="true" 
                       dataSourceProp="dimHierLevelsUI"
                       blockSize="10"                       
                       width="100%"
                       summaryBinding="HIERARCHIES@dimensionBundle@servletRequest"
                       alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>                       
          </uix:rowLayout>
        </uix:tableLayout>     
        </uix:header>
        <%-- end of hierarchies section --%>
        
        <%-- start of attributes section --%>
        <uix:header textBinding="ATTRIBUTES@dimensionBundle@servletRequest" size="1">
        
        <uix:tableLayout width="99%">
          <uix:rowLayout>                                  
           <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
           <uix:case name="true">
            <oem:table name="dimAttributesUI" beanKey="dimAttributesUIBean"
                       destination="/console/database/olap/dimension" 
                       formSubmitted="true"
                       dataSourceProp="dimAttributesUI"
                       blockSize="10"                       
                       width="100%"
                       summaryBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                       alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>                      
           </uix:case>
           <uix:case name="false">
             <uix:table name="dimAttributesUI"
                        width="100%"
                        minValue="1"
                        tableDataBinding="levelSelectedAttributes@dimensionBean@servletRequest"
                        formSubmitted="true"
                        maxValueBinding="length@dimensionBean@servletRequest"
                        blockSize="<%= DimensionBean.blockSize %>"
                        valueBinding="startIndex@dimensionBean@servletRequest"
                        summaryBinding="ATTRIBUTES@dimensionBundle@servletRequest"
                        alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LEVEL@dimensionBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="attributeLevel@dimensionBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="SELECTED_ATTRIBUTES@dimensionBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="attributeLevelSelectedColumn@dimensionBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="AVAILABLE_ATTRIBUTES@dimensionBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="attributeLevelAvailableColumn@dimensionBean@servletRequest"/>
            </uix:contents>
          </uix:column>
        </uix:table>
           </uix:case>
           </uix:switcher>
          </uix:rowLayout>
        </uix:tableLayout>        
        </uix:header>
        <%-- end of attributes section --%>

        <%-- start of OLAP options section --%>
        <%-- only display these if instance has OLAP option installed --%>
        <%-- need two switchers as header doesn't appear if header and table in on case - bug? --%>
        <uix:switcher childNameBinding="olapServerInstalled@dimensionBean@servletRequest">
          <uix:case name="true"> 
            <uix:header textBinding="OLAP_OPTIONS@dimensionBundle@servletRequest" size="1">
              <uix:tableLayout width="99%">
                <uix:rowLayout>                                  
                  <oem:table name="dimOLAPOptionsUI" beanKey="dimOLAPOptionsUIBean"
                             destination="/console/database/olap/dimension" formSubmitted="true"
                             dataSourceProp="dimOLAPOptionsUI"
                             blockSize="10"                       
                             width="100%"
                             summaryBinding="OLAP_OPTIONS@dimensionBundle@servletRequest"
                             alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>                        
                </uix:rowLayout>
              </uix:tableLayout>  
            </uix:header>
          </uix:case>
        </uix:switcher> 
        <%-- end of OLAP options section --%>

        <%-- start of join keys section --%>
        <uix:header textBinding="JOIN_KEYS@dimensionBundle@servletRequest" size="1"> 
        <uix:tableLayout width="99%">
          <uix:rowLayout>        
            <oem:table name="dimLevelJoinKeysUI" beanKey="dimLevelJoinKeysUIBean"
                       destination="/console/database/olap/dimension" formSubmitted="true"
                       blockSize="10" dataSourceProp="dimLevelJoinKeysUI"
                       width="100%"
                       summaryBinding="JOIN_KEYS@dimensionBundle@servletRequest"
                       alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"/>
          </uix:rowLayout>
        </uix:tableLayout>
        </uix:header>
        <%-- end of join keys section --%>    

      </uix:subTabLayout>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
          <uix:ref refID="pageButtonViewInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  
      
     </uix:pageLayout>  
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
