<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_COLUMNS@dimensionBundle@servletRequest"/>
      <script>
      function lovSelect(lovField)
      {
        var trailingList = document.selectColumnsForm.elements['Columns:trailing:items'].value;
        <%-- save the list of selected columns to be redisplayed again --%>
        opener.document.dimensionForm.selColList.value = trailingList;
        var leadingList = document.selectColumnsForm.elements['Columns:leading:items'].value;
        <%-- save the list of available columns to be redisplayed again --%>
        opener.document.dimensionForm.availColList.value = leadingList;
        <%-- turn semicolon-delimited list of selected columns (with a trailing ; in last position)
             to a comma-delimited list without a , in the last position --%>
        var commasList = trailingList.replace(/;/g, ", ");
        lovField.value = commasList.slice(0, commasList.length-2);
        window.close();
      }
      </script>
    </uix:metaContainer>

    <%@ include file="/database/global.jspf" %>

    <uix:form name="selectColumnsForm" method="post" destination="/console/database/olap/dimension">
    <uix:formValue name="pageName" value="/database/olap/dimension/selectColumns"/>

    <uix:stackLayout>
      <uix:header textBinding="SELECT_COLUMNS@dimensionBundle@servletRequest"/>
        <uix:styledText textBinding="SELECT_COLUMNS_FROM_LIST@dimensionBundle@servletRequest"/>
          <uix:tableLayout cellSpacing="2">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest"
                            destination="javascript:self.close()"/>
                <uix:button textBinding="SELECT@DBObjectBundle@servletRequest"
                            destinationBinding="selectValueDestination@servletRequest"/> 
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:header textBinding="COLUMNS@dimensionBundle@servletRequest"/>
                  <uix:contents>
                    <uix:stackLayout>                          
                      <uix:contentContainer width="70%">
                        <oem:shuttle name="Columns" 
                                     leadingHeaderBinding="AVAILABLE_COLUMNS@dimensionBundle@servletRequest"
                                     trailingHeaderBinding="SELECTED_COLUMNS@dimensionBundle@servletRequest" 
                                     size="10" reorderable="false" >
                          <uix:leading>
                            <oem:list name="availCols" multiple="true" selectedIndex="0"
                                      optionsBinding="availColNames@dimensionBean@servletRequest"/>
                          </uix:leading>
                          <uix:trailing>
                            <oem:list name="selCols" multiple="true" selectedIndex="0"
                                      optionsBinding="selColNames@dimensionBean@servletRequest"/>
                          </uix:trailing>
                        </oem:shuttle>
                      </uix:contentContainer>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          
          <uix:contentFooter>
            <uix:contents>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" 
                              destination="javascript:self.close()"/>
                  <uix:button textBinding="SELECT@DBObjectBundle@servletRequest" 
                              destinationBinding="selectValueDestination@servletRequest"/>
                </uix:contents>            
              </uix:pageButtonBar>
            </uix:contents>  
          </uix:contentFooter>

      </uix:stackLayout>
    </uix:form>
  </uix:document>
</uix:renderingContext>

