<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.adm.olap.dimension.DimensionBean" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

  <uix:metaContainer>
    <uix:head titleBinding="SELECT_TABLE@dimensionBundle@servletRequest"/>
    <db:script src="/cabo/jsLibs/TableProxy.js"/>    
<script>
function lovSelect(lovField)
{
    lenName = "tableUI:length";
    if ((document.forms[0][lenName] != null) && (lovField != null))
    {
        proxy = new TableProxy('tableUI');
        selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
            selectItem = "tableUI:cellValue:"+selectedIndex
            selectItemValue = document.forms[0][selectItem].value
            if (selectItemValue != selectItemValue.toUpperCase())
                selectItemValue = '"' + selectItemValue + '"';
            lovField.value = selectItemValue;
        }
    }
    window.close();
}
</script>
    
  </uix:metaContainer>

    <%@ include file="/database/global.jspf" %>

  <uix:body>
  <db:form name="selectValueForm" method="post" destinationBinding="destination@dimensionBean@servletRequest"
           copyParams="target,type,cancelURL,sname,oname,otype">
  <uix:formValue name="pageName" value="/database/olap/dimension/selectTable"/>

    <uix:stackLayout>
      <uix:header textBinding="SELECT_A_TABLE@dimensionBundle@servletRequest">
          <uix:stackLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:styledText textBinding="MSG_TEXT_SEARCH_ITEM@dimensionBundle@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:stackLayout>
                  <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
                    <uix:styledText textBinding="SCHEMA@uixDBObjectBundle@servletRequest" labeledNodeId="SCHEMA"/>
                    <uix:textInput name="filterSchema" textBinding="searchFilterSchema@dimensionBean@servletRequest" columns="15" id="SCHEMA" shortDescBinding="SCHEMA@uixDBObjectBundle@servletRequest" />
                    <uix:spacer height="1" width="7"/>
                    <uix:styledText textBinding="TABLE@dimensionBundle@servletRequest" labeledNodeId="TABLE"/>
                    <uix:textInput name="filterName" textBinding="searchFilterName@dimensionBean@servletRequest" columns="20" id="TABLE" shortDescBinding="TABLE@dimensionBundle@servletRequest"/>
                    <uix:submitButton textBinding="BUTTON_GO@dimensionBundle@servletRequest" name="event" value="searchEventTable" />
                  </uix:header>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>

        <uix:tableLayout cellSpacing="2" width="100%">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" destination="javascript:self.close()"/>
              <uix:spacer height="1" width="10"/>
              <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" destinationBinding="selectValueDestination@servletRequest"/> 
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>

            <uix:cellFormat>

              <uix:stackLayout>
                <uix:header textBinding="RESULTS@uixDBObjectBundle@servletRequest">

                  <uix:table name="tableUI"
                             width="100%"
                             minValue="1"
                             tableDataBinding="searchResultTable@dimensionBean@servletRequest"
                             formSubmitted="true"
                             maxValueBinding="searchResultTableLength@dimensionBean@servletRequest"
                             blockSize="<%= DimensionBean.blockSize %>"
                             valueBinding="startIndex@dimensionBean@servletRequest"
                             alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">

                    <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" />
                    </uix:tableSelection>

                    <%-- Table column name column --%>
                    <uix:column>
                      <uix:columnHeader>
                         <uix:styledText textBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                        <uix:styledText textBinding="searchResultSchemaName@dimensionBean@servletRequest"/>
                        <uix:formValue name="cellValue" valueBinding="searchResultTableItem@dimensionBean@servletRequest"/>
                      </uix:contents>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="TABLE@dimensionBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                        <uix:styledText textBinding="searchResultTableName@dimensionBean@servletRequest"/>
                      </uix:contents>
                    </uix:column>
                  </uix:table>
                </uix:header>

              </uix:stackLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>
    

      <uix:contentFooter>
        <uix:contents>
          <uix:pageButtonBar>
            <uix:contents>
              <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" destination="javascript:self.close()"/>
              <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" destinationBinding="selectValueDestination@servletRequest"/> 
            </uix:contents>
          </uix:pageButtonBar>
        </uix:contents>
      </uix:contentFooter>

    </uix:stackLayout>

  </db:form>
  </uix:body>

  </uix:document>
</uix:renderingContext>
