<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasureFolderEvent" %>
<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasfldrBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.MeasfldrMsg" />
    <uix:document>
      <uix:metaContainer>
      <uix:head titleBinding="title@measureFolderBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

    <uix:body>
    <db:form name="pageForm" method="post" destination="/console/database/olap/measfldr"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="<%= MeasureFolderEvent.MEASURE_FOLDER_ADD.getPageName() %>"/>
    <uix:formValue name="<%= MeasfldrBean.ATTRIBUTE_START_INDEX %>" valueBinding="startIndex@measureFolderBean@servletRequest" />
    <uix:pageLayout titleBinding="ADD_MEASURES@msg">

    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                        
        <%-- start of table of measures --%>
        <uix:header textBinding="LABEL_SEARCH@msg" size="1">
          <uix:styledText textBinding="MSG_TEXT_SEARCH_ITEM@msg"/>
          <uix:spacer height="15" width="5"/>
          <uix:stackLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" vAlign="bottom">
              <uix:contents>
                <uix:stackLayout>
                  <uix:styledText styleClass="OraPromptText" textBinding="COL_HEADER_SCHEMA@msg" labeledNodeId="SCHEMA" />
                    <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_SEARCH_SCHEMA_NAME %>" textBinding="searchSchema@measureFolderBean@servletRequest" columns="20" id="SCHEMA" shortDescBinding="COL_HEADER_SCHEMA@msg"/>
                 </uix:stackLayout>
                <uix:spacer height="1" width="4"/>
               </uix:contents>
             </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="bottom">
              <uix:contents>
                <uix:stackLayout>
                  <uix:styledText styleClass="OraPromptText" textBinding="COL_HEADER_CUBE_NAME@msg" labeledNodeId="CUBE_NAME"/>
                    <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_SEARCH_CUBE_NAME %>" textBinding="searchCube@measureFolderBean@servletRequest" columns="20" id="CUBE_NAME" shortDescBinding="COL_HEADER_CUBE_NAME@msg"/>
                </uix:stackLayout>
                <uix:spacer height="1" width="4"/>
             </uix:contents>
             </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="bottom">
              <uix:contents>
                <uix:stackLayout>
                  <uix:styledText styleClass="OraPromptText" textBinding="COL_HEADER_MEASURE_NAME@msg" labeledNodeId="MEASURE_NAME" />
                    <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_SEARCH_MEASURE_NAME %>" textBinding="searchMeasure@measureFolderBean@servletRequest" columns="20" id="MEASURE_NAME" shortDescBinding="COL_HEADER_MEASURE_NAME@msg"/>
                </uix:stackLayout>
                <uix:spacer height="1" width="4"/>
             </uix:contents>
             </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="bottom">
              <uix:contents>
                  <uix:submitButton textBinding="BUTTON_GO@msg" name="event" value="<%= MeasureFolderEvent.MEASURE_FOLDER_ADD_GO.getEventName() %>" shortDescBinding="BUTTON_GO@msg"/>
              </uix:contents>
             </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>
        </uix:header>

        <uix:header textBinding="AVAILABLE_MEASURES@msg" size="1">          
           
        <uix:tableLayout width="100%">
        <uix:rowLayout> 

        <uix:table name="<%= MeasfldrBean.ATTRIBUTE_UI_TABLE %>"
                   width="100%"
                   minValue="1"
                   tableDataBinding="measureAvailableData@measureFolderBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@measureFolderBean@servletRequest"
                   blockSizeBinding="blockSize@measureFolderBean@servletRequest"
                   valueBinding="startIndex@measureFolderBean@servletRequest"
                   summaryBinding="AVAILABLE_MEASURES@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">
          <uix:tableSelection>
            <uix:multipleSelection selectedBinding="<%= MeasfldrBean.ATTRIBUTE_IS_SELECTED %>" shortDescBinding="BUTTON_SELECT@msg" />
          </uix:tableSelection>
          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_SCHEMA@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_SCHEMA_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_CUBE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_CUBE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
               <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
             
           </uix:rowLayout>
         </uix:tableLayout>
      </uix:header>
         <%-- end of table --%>

      <%-- start of page level buttons section --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="BUTTON_CANCEL@msg" name="event" value="<%= MeasureFolderEvent.MEASURE_FOLDER_ADD_CANCEL.getEventName() %>" shortDescBinding="BUTTON_CANCEL@msg"/><uix:spacer height="1" width="1"/>  
              <uix:submitButton textBinding="BUTTON_OK@msg" name="event" value="<%= MeasureFolderEvent.MEASURE_FOLDER_ADD_OK.getEventName() %>" shortDescBinding="BUTTON_OK@msg"/><uix:spacer height="1" width="5"/>
          </uix:pageButtonBar>
        </uix:pageButtons>      
      <%-- end of page level buttons section --%>  

    </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
