<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasureFolderEvent" %>
<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasfldrBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.MeasfldrMsg" />
    <uix:document>
      <uix:metaContainer>
      <uix:head titleBinding="title@measureFolderBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>

    <uix:body>
    <db:form name="pageForm" method="post" destination="/console/database/olap/measfldr"
             copyParams="target,type,cancelURL,sname,oname,otype">
             
    <uix:formValue name="pageName" value="<%= MeasureFolderEvent.GENERAL_PROPERTY.getPageName() %>"/>
    <uix:pageLayout titleBinding="header@measureFolderBean@servletRequest">

    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

      <%-- start measure folder's general section --%>
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="44">
          <uix:spacer height="1" width="44"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt required="yes" promptBinding="LABEL_NAME@msg"/>
           </uix:cellFormat> 
          <uix:switcher childNameBinding="isCreating@measureFolderBean@servletRequest">        
            <uix:case name="true">                                
              <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_MEASURE_FOLDER_NAME %>" textBinding="measureFolderName@measureFolderBean@servletRequest" columns="48" onChange="this.value=this.value.toUpperCase()" shortDescBinding="LABEL_NAME@msg"/>
            </uix:case>
            <uix:case name="false">     
              <uix:styledText styleClass="OraDataText" textBinding="measureFolderName@measureFolderBean@servletRequest"/>                 
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:messagePrompt promptBinding="LABEL_DESCRIPTION@msg" labeledNodeId="LABEL_DESCRIPTION"/>
          </uix:cellFormat>
              <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_DESCRIPTION %>" textBinding="description@measureFolderBean@servletRequest" rows="3" wrap="soft" columns="50" shortDescBinding="LABEL_DESCRIPTION@msg" id="LABEL_DESCRIPTION"/>
        </uix:rowLayout>
            
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="LABEL_PARENT_FOLDER@msg" labeledNodeId="LABEL_PARENT_FOLDER"/>
          </uix:cellFormat>
            <uix:choice name="<%= MeasfldrBean.ATTRIBUTE_PARENT_FOLDER %>" selectedValueBinding="parentFolder@measureFolderBean@servletRequest" id="LABEL_PARENT_FOLDER">
              <uix:contents childDataBinding="parentFolderData@measureFolderBean@servletRequest">
                <uix:option textBinding="parentFolderText@measureFolderBean@servletRequest" valueBinding="parentFolderValue@measureFolderBean@servletRequest"/>
              </uix:contents>
            </uix:choice>
        </uix:rowLayout>   
                            
      </uix:tableLayout>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>
      <%-- end of details section --%>

         <%-- start of table of measures --%>
         <uix:header textBinding="LABEL_MEASURE@msg" size="1">          
           
         <uix:tableLayout width="100%">
           <uix:rowLayout hAlign="right">
            <uix:cellFormat hAlign="right" vAlign="top" width="100%">
               <uix:contents>
                  <uix:submitButton textBinding="BUTTON_ADD@msg" name="event" value="<%= MeasureFolderEvent.MEASURE_FOLDER_ADD.getEventName() %>" shortDescBinding="BUTTON_ADD@msg"/>
               </uix:contents>
             </uix:cellFormat>
           </uix:rowLayout>         
          <uix:rowLayout> 

        <uix:table name="<%= MeasfldrBean.ATTRIBUTE_UI_TABLE %>"
                   width="100%"
                   minValue="1"
                   tableDataBinding="measureFolderData@measureFolderBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@measureFolderBean@servletRequest"
                   blockSizeBinding="blockSize@measureFolderBean@servletRequest"
                   valueBinding="startIndex@measureFolderBean@servletRequest"
                   summaryBinding="LABEL_MEASURE@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedIndex@measureFolderBean@servletRequest" shortDescBinding="BUTTON_SELECT@msg">
              <uix:contents>
              <uix:submitButton textBinding="BUTTON_DELETE@msg" name="event" value="<%= MeasureFolderEvent.MEASURE_FOLDER_DELETE.getEventName() %>" shortDescBinding="BUTTON_DELETE@msg"/>
              </uix:contents>       
            </uix:singleSelection>  
          </uix:tableSelection>
          <%-- Table column name column --%>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="COL_HEADER_STATE@msg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:contents>
                  <uix:styledText styleClass="OraTipText" textBinding="<%= MeasfldrBean.ATTRIBUTE_STATE %>"/>
                </uix:contents>
              </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_SCHEMA@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_SCHEMA_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_CUBE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_CUBE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
               <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
             
           </uix:rowLayout>
         </uix:tableLayout>
      </uix:header>
         <%-- end of table --%>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  

    </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
