<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasureFolderEvent" %>
<%@ page import="oracle.sysman.emo.adm.olap.measfldr.MeasfldrBean" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.olap.MeasfldrMsg" />
    <uix:document>
      <uix:metaContainer>
      <uix:head titleBinding="viewTitle@measureFolderBean@servletRequest"/>
        <db:script src="/database/utils.js"/>      
      </uix:metaContainer>
    <uix:body>
    <db:form name="pageForm" method="post" destination="/console/database/olap/measfldr"
             copyParams="target,type,cancelURL,sname,oname,otype">
    <uix:formValue name="pageName" value="<%= MeasureFolderEvent.PAGENAME_MEASURE_FOLDER_VIEW %>"/>
    <uix:pageLayout titleBinding="viewHeader@measureFolderBean@servletRequest">

    <%@ include file="/oemGlobal.jspf" %>
    
    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

      <%-- start measure folder's general section --%>
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout hAlign="left">
        <uix:cellFormat width="44">
          <uix:spacer height="1" width="44"/>
        </uix:cellFormat>
        <uix:cellFormat width="*">
          <uix:tableLayout cellSpacing="5"> 

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt required="yes" promptBinding="LABEL_NAME@msg"/>
           </uix:cellFormat> 
              <uix:styledText styleClass="OraDataText" textBinding="measureFolderName@measureFolderBean@servletRequest"/>                 
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:messagePrompt promptBinding="LABEL_DESCRIPTION@msg" labeledNodeId="LABEL_DESCRIPTION"/>
          </uix:cellFormat>
              <uix:textInput name="<%= MeasfldrBean.ATTRIBUTE_DESCRIPTION %>" textBinding="description@measureFolderBean@servletRequest" rows="3" wrap="soft" columns="50" disabled="true" shortDescBinding="LABEL_DESCRIPTION" id="LABEL_DESCRIPTION"/>
        </uix:rowLayout>
              
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="LABEL_PARENT_FOLDER@msg"/>
          </uix:cellFormat>
             <uix:styledText styleClass="OraDataText" textBinding="parentFolderName@measureFolderBean@servletRequest"/>                 
        </uix:rowLayout>   
                            
      </uix:tableLayout>
    </uix:cellFormat> 
    </uix:rowLayout>
</uix:tableLayout>
      <%-- end of details section --%>

         <%-- start of table of measures --%>
         <uix:header textBinding="LABEL_MEASURE@msg" size="1">          
           
        <uix:table name="<%= MeasfldrBean.ATTRIBUTE_UI_TABLE %>"
                   width="100%"
                   minValue="1"
                   tableDataBinding="measureFolderData@measureFolderBean@servletRequest"
                   formSubmitted="true"
                   maxValueBinding="length@measureFolderBean@servletRequest"
                   blockSizeBinding="blockSize@measureFolderBean@servletRequest"
                   valueBinding="startIndex@measureFolderBean@servletRequest"
                   summaryBinding="LABEL_MEASURE@msg"
                   alternateTextBinding="MSG_NO_OBJECT_FOUND@msg">
          <%-- Table column name column --%>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_SCHEMA@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_SCHEMA_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_CUBE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_CUBE_NAME %>"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="COL_HEADER_MEASURE_NAME@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
               <uix:styledText textBinding="<%= MeasfldrBean.ATTRIBUTE_MEASURE_NAME %>"/>
            </uix:contents>
          </uix:column>
        </uix:table>
             
           
      </uix:header>
         <%-- end of table --%>

      <%-- start of page level buttons section --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
          <uix:ref refID="pageButtonViewInclude" />
       </uix:pageButtonBar>
      </uix:pageButtons>      
      <%-- end of page level buttons section --%>  

    </uix:pageLayout>
    </db:form>
    </uix:body>
    </uix:document>
</uix:renderingContext>
