<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msg" class="oracle.sysman.db.rsc.osm.OsmObjectMsg" />
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form
      name="diskGrpForm" 
      method="post"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/addDisks"/>

      <uix:formValue 
        name="cancelURL" 
        valueBinding="cancelURL@servletRequest"/>

      <uix:pageLayout titleBinding="ADD_DISK_S@OsmObjectBundle@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

       <%@ include file="rebalance.jsp" %>
       <uix:header textBinding="CANDIDATE_MEMBER_DISKS@msg" >
             <oem:table 
                    width="100%" 
                    blockSizeBinding="blockSize@selectDiskUIDataSource@diskGrp@servletRequest"
                    formSubmitted="true"
                    name="selectDiskUIDataSource" 
                    dataSourceProp="selectDiskUIDataSource"
                    beanKey="diskGrp"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    summaryBinding="MEMBER_DISKS@msg"
                    >
                 <uix:tableFilter>
                   <uix:rowLayout>
                     <uix:contents>
                       <uix:cellFormat hAlign="left" vAlign="middle" wrappingDisabled="true">
                       <uix:styledText labeledNodeId="searchCriteria" textBinding="SELECT_DISKS@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                       </uix:cellFormat>
                       <uix:cellFormat hAlign="left" vAlign="middle">
                       <uix:choice id="searchCriteria" name="searchCriteria"
                        selectedValueBinding="searchCriteria@selectDiskDataSource@diskGrp@servletRequest"
                        onChange="submitForm('diskGrpForm',true,{'event':'headerFilter'})">
                       <uix:option textBinding="SHOW_CANDIDATES@OsmObjectBundle@servletRequest" value="CANDIDATES"/> 
                       <uix:option textBinding="SHOW_ALL@OsmObjectBundle@servletRequest" value="ALL"/>
                       </uix:choice>
                     </uix:cellFormat>
                   </uix:contents>                    
                </uix:rowLayout>
              </uix:tableFilter>
            </oem:table>
            <uix:spacer height="5"/>
            <uix:tip renderedBinding="verGE112@osmAdminBean@servletRequest">
               <contents>
                 <uix:styledText styleClass="oraTipText"
                                 textBinding="ADD_QUORUM_DG_TIP@OsmObjectBundle@servletRequest"/>
               </contents>
            </uix:tip>
		<uix:switcher childNameBinding="memberDiskSelected@diskGrp@servletRequest">
			<uix:case name="true">    	
			<uix:messageText messageBinding="MEMBER_DISK_SELECTION_LOST_MSG@OsmObjectBundle@servletRequest"
                             messageType="warning"/>
			</uix:case>				
		</uix:switcher>   	              
       </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
              value="showSql"/>
              <%---  CREATE  ---%>
                <uix:flowLayout>
                  <uix:submitButton 
                    name="event" 
                    textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                    value="cancel"/>  
               <uix:spacer height="10" width="10" />
                  <uix:submitButton
                    name="event" 
                    textBinding="OK@uixDBObjectBundle@servletRequest"
                    value="progress"/>
                </uix:flowLayout>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

