<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="credsMsgs" 
              class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <%-- HTML Page Title --%>
 <%--   <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
--%>
    <uix:body>
    <uix:form
      name="asmOSUserForm"
      method="post"
      destinationBinding="defaultURL@servletRequest">
      <uix:formValue name="pageName" value="/database/osm/addOsUser"/>
      <uix:formValue name="optionChoice"
                     valueBinding="optionChoice@servletRequest"/>
    <uix:pageLayout titleBinding="ADD_USER@osmMsgs">
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:rowLayout hAlign="center">
  
              <uix:spacer width="10"/>
              <uix:messagePrompt 
                              promptBinding="addHeader@defaultBean@servletRequest"/>
             </uix:rowLayout> 
             
            <uix:header text="">
             
            <uix:rowLayout>
             <uix:spacer width="10"/>
            
             <uix:tableLayout width="100%">
            
              <uix:rowLayout>
               <uix:messagePrompt 
                              promptBinding="DG_ADD_OS_USER_INSTR@OsmObjectBundle@servletRequest"/>
              </uix:rowLayout>
              
              <uix:rowLayout>
               <uix:spacer height="15"/>
              </uix:rowLayout>
              
              <uix:rowLayout>
               <uix:tableLayout>
                <uix:rowLayout>
                <uix:cellFormat hAlign="right" >
                  <uix:styledText styleClass="OraPromptText"
                                  labeledNodeId="osUsers" 
                                  textBinding="OPERATING_SYSTEM_USERS@OsmObjectBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                <uix:spacer width="5" height="1"/>
                </uix:cellFormat>
                <uix:cellFormat>
                      <uix:textInput id="osUsers"
                                     name="osUsers"
                                     textBinding="osUsers@asmSystemUser@servletRequest"
                                     columns="40"/>
                 </uix:cellFormat>
                 </uix:rowLayout>
                 
                 <uix:rowLayout>
                 <uix:cellFormat/>
                 <uix:cellFormat/>
                   <uix:cellFormat>
                     <uix:styledText textBinding="OPEARTING_SYSTEM_USERS_TIP@OsmObjectBundle@servletRequest"
                                       styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:rowLayout>
            </uix:header>
                  
       <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton name="event"
                              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              value="showSql"/>
            <uix:button   textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          destinationBinding="cancelURL@servletRequest"/>
            <uix:submitButton
              name="event"
              textBinding="OK@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
    </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
  