<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form name="foo" method="POST" 
      destinationBinding="defaultURL@servletRequest">
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="mname" valueBinding="mname@servletRequest"/>               
      <uix:formValue name="otype" valueBinding="otype@servletRequest"/>               
      <uix:formValue name="oname" valueBinding="oname@servletRequest"/>    
      <uix:formValue name="index" valueBinding="index@servletRequest"/>            
      <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>            
      <uix:formValue 
       name="pageName" 
        value="/database/osm/aliasPage"/>

    <uix:pageLayout titleBinding="fileHeader@servletRequest">
     <%@ include file="/database/global.jspf" %>   

     <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- uix:header
          textBinding="fileHeader@servletRequest"
          --%>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <uix:rowLayout>
                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="originalPrompt@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="mname@servletRequest"/>
                 </uix:cellFormat>
                </uix:rowLayout>
                
                <uix:rowLayout>                
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt required="yes" labeledNodeId="newValue"
                      promptBinding="newPrompt@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:stackLayout>
                    <uix:contents>
                        <uix:textInput id="newValue"
                          name="newValue"
                          textBinding="newValue@servletRequest"
                          columns="50"/>
                        <uix:messageText messageBinding="Name@errors@servletRequest"
                                         messageType="error"/>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:rowLayout>
                
           </uix:tableLayout>     
        <%-- /uix:header --%>  

        <uix:pageButtons>
         <uix:pageButtonBar>
	  <uix:submitButton  name="event" 
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" value="showSql"/>
	    
	    <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 	
			destinationBinding="cancelURL@servletRequest" />  
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"  
			      name="event" value="apply"/>                      
         </uix:pageButtonBar>
        </uix:pageButtons>

    </uix:pageLayout>
    </uix:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
