<%--
  -- Page:        badBlockRecoveryPage.jsp
  -- Controller:  oracle.sysman.db.adm.osm.BadBlckRcvyController
  --
  -- Description: ASM metadata backup configuration page
  --
  --  MODIFIED    (MM/DD/YY)
  --     dchakumk 03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                         st_emdbsa_11.1
  --     gmahaney 02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     qsong    03/02/06 - Creation
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="credsMsgs" 
              class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <%-- HTML Page Title --%>
    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <uix:form
      name="badBlockForm"
      method="post"
      destinationBinding="badBlckRcvyDest@servletRequest">
      <uix:formValue name="pageName" value="/database/osm/badBlockRecoveryPage"/>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="header@defaultBean@servletRequest">
          <uix:styledText textBinding="BAD_BLOCK_RECOVERY_INSTR@osmMsgs" 
                          styleClass="OraInstructionText" />
          <uix:tableLayout width="80%" cellSpacing="5">
          <%-- Add restore related UI here --%>
            <uix:rowLayout>

              <%-- Block Physical Numbers --%>
              <uix:cellFormat width="50%" vAlign="top">
                <uix:header textBinding="PHYSICAL_BLOCK_NUM@osmMsgs">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                    <uix:stackLayout>
                     <uix:labeledFieldLayout labelWidth="25">
                      <uix:messageTextInput 
                                   name="blockNumberFrom"
                                   promptBinding="FROM_BLOCK_NUM@osmMsgs"
                                   textBinding="blockNumberFrom@defaultBean@servletRequest"
                                   required="yes"
                                   columns="20">
                        <uix:onSubmitValidater>
                          <uix:decimal maxScale="0"/>
                        </uix:onSubmitValidater>
                      </uix:messageTextInput>
                      <uix:messageTextInput 
                                   name="blockNumberTo"
                                   promptBinding="TO_BLOCK_NUM@osmMsgs"
                                   textBinding="blockNumberTo@defaultBean@servletRequest"
                                   required="yes"
                                   columns="20">
                        <uix:onSubmitValidater>
                          <uix:decimal maxScale="0"/>
                        </uix:onSubmitValidater>
                      </uix:messageTextInput>
                     </uix:labeledFieldLayout> 
                     <uix:messageText messageBinding="blockNumberTo@errors@servletRequest"
                                       messageType="error"/>
                    </uix:stackLayout>
                    </uix:rowLayout>
                  </uix:tableLayout> 
                </uix:header> 
              </uix:cellFormat>

              <%-- Host Credentials --%>
              <uix:cellFormat width="50%" vAlign="top">
                <uix:header textBinding="HOST_CREDS@osmMsgs">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:radioButton 
                        name="useCredOption"
                        textBinding="USE_PREF_CREDS@osmMsgs"
                        value="usePrefCreds" 
                        disabledBinding="disablePrefCreds@defaultBean@servletRequest"
                        selectedBinding="usePrefCredsOption@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:tableLayout>
                    <uix:rowLayout>
                    <uix:cellFormat width="25"/>
                      <uix:styledText textBinding="NO_PREF_CRED_SET@osmMsgs"
                                      styleClass="OraInlineInfoText" 
                                      renderedBinding="disablePrefCreds@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:radioButton 
                            name="useCredOption"
                            textBinding="specifyCredsPrompt@servletRequest"
                            value="userCreds" 
                            selectedBinding="userCredsOption@defaultBean@servletRequest"/>
                        </uix:rowLayout>

                        <uix:tableLayout cellSpacing="5"> 
                          <uix:rowLayout>
                           <%@ include file="/credentials.jspf" %> 
                          </uix:rowLayout>
                        </uix:tableLayout>

                      </uix:tableLayout>
                    </uix:rowLayout>

                    </uix:tableLayout>
                </uix:header> 
              </uix:cellFormat>
            </uix:rowLayout>
	        </uix:tableLayout>
        </uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton
                 name="event" 
                 textBinding="SHOWCMD@dbMsgs"
                 value="showCmd"/>
            <uix:submitButton
                 name="event" 
                 textBinding="SCHEDULE_JOB@dbMsgs"
                 value="submitJob"/>
            <uix:button
                 textBinding="CANCEL@dbMsgs"
                 destinationBinding="cancelURL@servletRequest"/>  
            <uix:submitButton
                 name="event" 
                 textBinding="OK@dbMsgs"
                 value="<%= OsmConst.EVENT_DO_BB_RCVY %>"/>
          </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

