<%--
  -- Page:        checkPage.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmAdminController
  --
  -- Description: Check diskgroup configuration page
  --
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.adm.osm.OsmConst"%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:bundle name="dbMsgs" 
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="credsMsgs" 
              class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <%-- HTML Page Title --%>
 <%--   <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
--%>
    <uix:body>
    <uix:form
      name="checkDiskgroupForm"
      method="post"
      destinationBinding="checkDGDest@servletRequest">
      <uix:formValue name="pageName" value="/database/osm/checkPage"/>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


        <uix:header textBinding="header@defaultBean@servletRequest">
          <uix:styledText textBinding="CHECK_DG_INSTR@osmMsgs" 
                          styleClass="OraInstructionText" />
          <uix:tableLayout width="80%" cellSpacing="5">
          <%-- Add restore related UI here --%>
            <uix:rowLayout>

              <%-- Block Physical Numbers --%>
              <uix:cellFormat width="50%" vAlign="top">
                <uix:header textBinding="CHECK_OPTIONS@osmMsgs">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:radioButton name="option" 
                                       value="NOREPAIR"
                                        textBinding="CHECK_WITHOUT_REPAIR@OsmObjectBundle@servletRequest"
                                       selectedValueBinding="option@defaultBean@servletRequest" />
                      <uix:styledText styleClass="oraTipText"
                            textBinding="CHECK_WITHOUT_REPAIR_HINT@OsmObjectBundle@servletRequest"/>
                  </uix:stackLayout>
                 </uix:contents>
                </uix:rowLayout>
                 <uix:rowLayout>
                  <uix:spacer height="6"/>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:radioButton name="option"
                                       value="REPAIR"
                                       textBinding="CHECK_AND_REPAIR@OsmObjectBundle@servletRequest"
                                       selectedValueBinding="option@defaultBean@servletRequest" />
                      <uix:styledText styleClass="oraTipText"
                            textBinding="CHECK_AND_REPAIR_HINT@OsmObjectBundle@servletRequest"/>
                    </uix:stackLayout>
                 </uix:contents>
                </uix:rowLayout>
                  </uix:tableLayout> 
                </uix:header> 
              </uix:cellFormat>

              <%-- Host Credentials --%>
             <%-- <uix:cellFormat width="50%" vAlign="top">
                <uix:header textBinding="HOST_CREDS@osmMsgs">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:radioButton 
                        name="useCredOption"
                        textBinding="USE_PREF_CREDS@osmMsgs"
                        value="usePrefCreds" 
                        disabledBinding="disablePrefCreds@defaultBean@servletRequest"
                        selectedBinding="usePrefCredsOption@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:tableLayout>
                    <uix:rowLayout>
                    <uix:cellFormat width="25"/>
                      <uix:styledText textBinding="NO_PREF_CRED_SET@osmMsgs"
                                      styleClass="OraInlineInfoText" 
                                      renderedBinding="disablePrefCreds@defaultBean@servletRequest"/>
                    </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:radioButton 
                            name="useCredOption"
                            textBinding="specifyCredsPrompt@servletRequest"
                            value="userCreds" 
                            selectedBinding="userCredsOption@defaultBean@servletRequest"/>
                        </uix:rowLayout>

                        <uix:tableLayout cellSpacing="5"> 
                          <uix:rowLayout>
                           <%@ include file="/credentials.jspf" %> 
                          </uix:rowLayout>
                        </uix:tableLayout>

                      </uix:tableLayout>
                    </uix:rowLayout>

                    </uix:tableLayout>
                </uix:header> 
              </uix:cellFormat> --%>
            </uix:rowLayout>
	        </uix:tableLayout>
        </uix:header>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton
                 name="event" 
                 textBinding="SHOWSQL@dbMsgs"
                 value="showSql"/>
            <uix:submitButton
                 name="event" 
                 textBinding="SCHEDULE_JOB@dbMsgs"
                 value="submitJob"/>
            <uix:button
                 textBinding="CANCEL@dbMsgs"
                 destinationBinding="cancelURL@servletRequest"/>  
            <uix:submitButton
                 name="event" 
                 textBinding="OK@dbMsgs"
                 value="apply"/>
          </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

