<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="DISKGROUP_MGMT@OsmObjectBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <uix:form
      name="osmForm" 
      method="GET"
      destination="/console/database/osm/osmAdmin">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/clientDBs"/>

      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header  textBinding="DISKGROUP_MGMT@OsmObjectBundle@servletRequest">

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:contents>
                <uix:link textBinding="DISKGROUPS@OsmObjectBundle@servletRequest" onClick="submitForm('osmForm', true, {event:'dgTab'})"/>
                <uix:link textBinding="DB_INSTANCES@OsmObjectBundle@servletRequest"/>
                </uix:contents>
              </uix:subTabBar> 
            </uix:subTabs>
                  <oem:table 
                    width="80%"
                    formSubmitted="true"
                    name="clientDBsTableUI"
                    dataSourceProp="clientDBsTableUI"
                    beanKey="osmAdminBean"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
                </oem:table>
            

          </uix:subTabLayout>

        </uix:header>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

