<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form
      name="diskGrpForm" 
      method="post"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/createDG"/>

      <uix:formValue 
        name="cancelURL" 
        valueBinding="cancelURL@servletRequest"/>

      <uix:pageLayout titleBinding="header@diskGrp@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

            <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5"  >

                <%---------------------%>
                <%---  DG Name    ---%>
                <%---------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt required="yes" labeledNodeId="diskGroupName" 
                      promptBinding="NAME@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                        <uix:textInput id="diskGroupName" 
                          name="diskGroupName"
                          textBinding="diskGroupName@diskGrp@servletRequest"
                          columns="50"/>
                  </uix:cellFormat>

                </uix:rowLayout>
     
                <%--------------------------%>
                <%---  Redundancy ---%>
                <%--------------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText
                      styleClass="OraPromptText"
                      textBinding="REDUNDANCY@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
		  
                  <%---  Field  ---%>
                  <uix:cellFormat>
                   <uix:contents> 
                    <uix:radioButton 
                      name="redundancy"
                      textBinding="HIGH@OsmObjectBundle@servletRequest" value="HIGH" selectedBinding="high@diskGrp@servletRequest"/>
                    <uix:radioButton 
                      name="redundancy"
                      textBinding="NORM@OsmObjectBundle@servletRequest" value="NORMAL" selectedBinding="normal@diskGrp@servletRequest"/>
                    <uix:radioButton 
                      name="redundancy"
                      textBinding="EXTERN@OsmObjectBundle@servletRequest" value="EXTERNAL" selectedBinding="external@diskGrp@servletRequest"/>
                   </uix:contents>                       
                  </uix:cellFormat>

                </uix:rowLayout>
                <%--------------------------%>
                <%---  Allocation Unit   ---%>
                <%--------------------------%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                    <uix:styledText
                      labeledNodeId="allocationUnitSize"
                      styleClass="OraPromptText"
                      textBinding="ALLOCATION_UNIT_MB@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                   <uix:contents>
                   <uix:stackLayout >
                     <uix:contents>
                       <uix:choice id="allocationUnitSize" 
                                  name="allocationUnitSize"
                                   selectedValueBinding="allocationUnitSize@diskGrp@servletRequest" >
                        <uix:option text="1" value="1"/>
                        <uix:option text="2" value="2"/> 
                        <uix:option text="4" value="4"/> 
                        <uix:option text="8" value="8"/> 
                        <uix:option text="16" value="16"/> 
                        <uix:option text="32" value="32"/> 
                        <uix:option text="64" value="64"/>                          
                       </uix:choice> 
                       <uix:rowLayout width ="60%">
                       <uix:styledText textBinding="ALLOCATION_UNIT_HINT@OsmObjectBundle@servletRequest"
                                     styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                     </uix:contents>
                    </uix:stackLayout>
                    
                    </uix:contents>
                </uix:cellFormat>
                </uix:rowLayout>
                
 
                <%-------------------------%>
                <%---  Mount to all instances  ---%>
                <%-------------------------%>
                <uix:rowLayout renderedBinding="racAsm@diskGrp@servletRequest">

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">                    
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <uix:checkBox
                      name="mountAllOnCreate"
                      checkedBinding="mountAllOnCreate@diskGrp@servletRequest"
                      textBinding="MOUNT_TO_ALL_INSTANCES@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>

                </uix:rowLayout>

            </uix:tableLayout>

            <%---------------------------
             -   Select Disks Table        -
             ---------------------------%>
             <uix:header textBinding="CANDIDATE_MEMBER_DISKS@OsmObjectBundle@servletRequest" >
             <oem:table summaryBinding="CANDIDATE_MEMBER_DISKS@OsmObjectBundle@servletRequest"
                    width="100%" 
                    blockSizeBinding="blockSize@selectDiskUIDataSource@diskGrp@servletRequest"
                    formSubmitted="true"
                    name="selectDiskUIDataSource" 
                    dataSourceProp="selectDiskUIDataSource"
                    beanKey="diskGrp"
                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                    >
                 <uix:tableFilter>
                   <uix:rowLayout>
                     <uix:contents>
                       <uix:cellFormat hAlign="left" vAlign="middle" wrappingDisabled="true">
                       <uix:styledText labeledNodeId="searchCriteria" textBinding="SELECT_DISKS@OsmObjectBundle@servletRequest" styleClass="OraPromptText" />                      
                       </uix:cellFormat>
                       <uix:cellFormat hAlign="left" vAlign="middle">
                       <uix:choice id="searchCriteria" name="searchCriteria"
                        selectedValueBinding="searchCriteria@selectDiskDataSource@diskGrp@servletRequest"
                        onChange="submitForm('diskGrpForm',true,{'event':'headerFilter'})">
                       <uix:option textBinding="SHOW_CANDIDATES@OsmObjectBundle@servletRequest" value="CANDIDATES"/> 
                       <uix:option textBinding="SHOW_ALL@OsmObjectBundle@servletRequest" value="ALL"/>
                       </uix:choice>
                     </uix:cellFormat>
                   </uix:contents>                    
                </uix:rowLayout>
              </uix:tableFilter>
            </oem:table>
          <uix:spacer height="5"/>
          <uix:tip renderedBinding="verGE112@osmAdminBean@servletRequest">
                <contents>
                  <uix:styledText styleClass="oraTipText"
                                  textBinding="CREATE_QUORUM_DG_TIP@OsmObjectBundle@servletRequest"/>
                </contents>
              </uix:tip>
	    <uix:switcher childNameBinding="memberDiskSelected@diskGrp@servletRequest">
		<uix:case name="true">    	
			<uix:messageText messageBinding="MEMBER_DISK_SELECTION_LOST_MSG@OsmObjectBundle@servletRequest"
                             messageType="warning"/>
		</uix:case>				
	    </uix:switcher>             
           </uix:header>
            

      <%-----------------------------------%>
      <%---  Disk Group Compatibility   ---%>
      <%-----------------------------------%>
        <uix:header textBinding="DISKGROUP_COMPATIBILITY@OsmObjectBundle@servletRequest" renderedBinding="versionGte11g@diskGrp@servletRequest">
          <uix:stackLayout >
          <uix:messagePrompt 
                    promptBinding="CREATEDG_COMPATIBILITY_INSTR@OsmObjectBundle@servletRequest"/>
          <uix:spacer height="15"/>
          <uix:rowLayout>
          <uix:spacer height="15"/>
          
          <uix:tableLayout cellSpacing="10">
            <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="databaseCompatibility"
                                textBinding="DATABASE_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:stackLayout>
                  <uix:contents>
                    <uix:textInput id="databaseCompatibility"
                                   name="databaseCompatibility"
                                   textBinding="databaseCompatibility@diskGrp@servletRequest"
                                   columns="30"/>
                     <uix:styledText textBinding="DATABASE_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest"
                                     styleClass="OraInlineInfoText"/>
                     <uix:messageText messageBinding="(DATABASE_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
                 </uix:contents>
              </uix:stackLayout>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="asmCompatibility"
                                textBinding="ASM_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:stackLayout>
                  <uix:contents>
                    <uix:textInput id="asmCompatibility"
                                   name="asmCompatibility"
                                   textBinding="asmCompatibility@diskGrp@servletRequest"
                                   columns="30"/>
                     <uix:styledText textBinding="ASM_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest"
                                     styleClass="OraInlineInfoText"/>
                     <uix:messageText messageBinding="(ASM_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
                 </uix:contents>
              </uix:stackLayout>
             </uix:rowLayout>
            <uix:rowLayout vAlign="top" renderedBinding="isVersionGte11gTB@diskGrp@servletRequest">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="advmCompatibility"
                                textBinding="ADVM_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:stackLayout>
                  <uix:contents>
                    <uix:textInput id="advmCompatibility"
                                   name="advmCompatibility"
                                   textBinding="advmCompatibility@diskGrp@servletRequest"
                                   columns="30"/>
                     <uix:styledText textBinding="ADVM_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest"
                                     styleClass="OraInlineInfoText"/>
                     <uix:messageText messageBinding="(ADVM_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
                 </uix:contents>
              </uix:stackLayout>
             </uix:rowLayout>
            
          </uix:tableLayout>
          </uix:rowLayout>
          
         <uix:rowLayout>
         <uix:spacer width="51" height="1"/>
          <uix:tip>
            <contents> 
	      <uix:switcher childNameBinding="versionGte11gTB@diskGrp@servletRequest">
		<uix:case name="true">    	
                  <uix:styledText styleClass="oraTipText" textBinding="DISKGROUP_AVDM_COMPATIBILITY_TIP@OsmObjectBundle@servletRequest"/>
 		</uix:case>				
		<uix:default>    	
                  <uix:styledText styleClass="oraTipText" textBinding="DISKGROUP_COMPATIBILITY_TIP@OsmObjectBundle@servletRequest"/>
 		</uix:default>				
	      </uix:switcher>             
            </contents>
           </uix:tip>
        </uix:rowLayout>
       
        </uix:stackLayout >
        </uix:header>
     
      <%---------------------------%>
      <%--- DISK REPAIR TIME    ---%>
      <%---------------------------%>
      <%--
        <uix:header textBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest" renderedBinding="versionGte11g@diskGrp@servletRequest" >
          <uix:stackLayout >
          <uix:messagePrompt 
                    promptBinding="DISK_REPAIR_TIME_INSTR@OsmObjectBundle@servletRequest"/>
          <uix:spacer height="15"/>
          <uix:rowLayout>
         
          <uix:tableLayout cellSpacing="10">
             <uix:spacer height="5"/>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                 <uix:styledText labeledNodeId="idDiskRepairTime" 
                                textBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest" 
                                styleClass="OraPromptText" />
              </uix:cellFormat>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:rowLayout >
                     <uix:textInput  name="diskRepairTime" id="diskRepairTime"
                                     textBinding="diskRepairTime@diskGrp@servletRequest" columns="4"/>
                       <uix:choice id="DiskRepairTimeOption" 
                                   name="diskRepairTimeOption"
                                   selectedValueBinding="diskRepairTimeOption@diskGrp@servletRequest">
                            <uix:option textBinding="MINUTES@OsmObjectBundle@servletRequest" value="m"/> 
                            <uix:option textBinding="HOURS@OsmObjectBundle@servletRequest" value="h"/> 
                            <uix:option textBinding="DAYS@OsmObjectBundle@servletRequest" value="d"/> 
                         </uix:choice>
                      </uix:rowLayout>
                     <uix:styledText textBinding="DISK_REPAIR_TIME_HINT@OsmObjectBundle@servletRequest"
                                     styleClass="OraInlineInfoText"/>
                     <uix:messageText messageBinding="diskRepairTime@errors@servletRequest"
											                messageType="error" />
                  </uix:contents>
                </uix:stackLayout>
              </uix:rowLayout>
          </uix:tableLayout>
          </uix:rowLayout>
         </uix:stackLayout >
        </uix:header>
        --%>

        <%-------------------------
         -  Footer
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton
              name="event" 
              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
              value="showSql"/>
              <%---  CREATE  ---%>
                  <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      destinationBinding="cancelURL@servletRequest" />                      
                  <uix:submitButton
                    name="event" 
                    textBinding="OK@uixDBObjectBundle@servletRequest"
                    value="apply"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

