<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.db.adm.osm.OsmAdminController"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form name="foo" destinationBinding="commandURL@servletRequest">
    <uix:pageLayout>   
     <%@ include file="/database/global.jspf" %>  
       <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     
      <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>         
      <uix:formValue name="pageName" value="/database/osm/deleteConfirmation"/>
      
      <uix:header iconBinding="confirmationIcon@servletRequest" textBinding="CONFIRMATION@OsmObjectBundle@servletRequest"/> 
      <uix:tableLayout > 
       <uix:rowLayout >
         <uix:cellFormat >
           <uix:spacer width="40"/>
         </uix:cellFormat>
         <uix:cellFormat >
           <uix:stackLayout >
             <uix:spacer width="10" height="20"/>
             <uix:styledText styleClass="OraDataText" textBinding="confirmationText@servletRequest"/>
             <uix:spacer width="10" height="20"/>
             <uix:hideShow id="idShowHideDelete" 
                           formSubmitted="true" 
                           renderedBinding="showAdvancedOption@servletRequest" 
                           disclosedBinding="showHideOption@servletRequest" 
                           disclosedTextBinding="HIDE_SQL@OsmObjectBundle@servletRequest" 
                           undisclosedTextBinding="SHOWSQL@uixDBObjectBundle@servletRequest">
              <uix:contents>
               <%-- START: TAB CONTENTS starts here --%>
      <uix:stackLayout>
       <uix:spacer width="10" height="20"/>
       <uix:rowLayout>
          <uix:spacer width="25"/>
          <db:sqlDisplay  sqlListBinding="sqlList@mainEmoBean@servletRequest"/> 
        </uix:rowLayout>
      </uix:stackLayout>

    <%-- END: TAB CONTENTS ends here --%> 
              </uix:contents>
            </uix:hideShow>
           </uix:stackLayout>
        </uix:cellFormat>
       </uix:rowLayout>
      </uix:tableLayout>
        
      <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:contents>
	    <%-- Show Sql --%>
	    <uix:switcher childNameBinding="showSQL@servletRequest">
	     <uix:case name="true">
           <uix:submitButton name="event" textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" value="showSql"/>
         </uix:case>
        </uix:switcher>
	    <%-- Advanced options --%>         
	    <uix:switcher childNameBinding="advancedOptionsAvailable@servletRequest">
	     <uix:case name="true">
              <uix:submitButton textBinding="ADVANCED_OPTIONS@OsmObjectBundle@servletRequest"  name="event" value="showAdvancedOptions"/>            
             </uix:case>
            </uix:switcher>
            <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest" />  
            <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest"  name="event" value="apply"/>            
          </uix:contents>
        </uix:pageButtonBar>
      </uix:contentFooter>

    </uix:pageLayout>
    </uix:form>    
  </uix:body>
  </uix:document>
</uix:renderingContext>
