<%--
  -- Page:       dgHistPerformanceInclude.jsp
  -- Controller: oracle.sysman.db.adm.osm.OsmHealthController
  --
  -- Description: ASM resource access warning include
  --
  --  MODIFIED    (MM/DD/YY)
  --   mpawelko    02/23/09 - backport 6525227: remove hardcoded thresholds
  --   mpawelko    07/16/08 - use OP_SIZE msg for Operation Size
  --   qsong       06/16/06 - Creation 
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="dgHistPerformanceInclude">
<uix:dataScope>

  <uix:stackLayout renderedBinding="histChartOption@healthBean@servletRequest">

   <oem:chart titleBinding="RESPONSE_TIME@OsmObjectBundle@servletRequest"
               chartType="timeSeriesChart"
               format="svg"
               orientation="vertical"
               width="650"
               height="160"
               legendPosition="east"
               legendVisible="external"
               externalLegendOrientation="vertical"
               svgHighlightLegend="true"
               seriesColorsAutomatic="true"
               yAxisLabelBinding="MS_PER_OPERATION@OsmObjectBundle@servletRequest">
      <uix:contents>
        <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                        defaultLabel="true" />
        <oem:boundChartDataSource
             chartDataSourceBinding="responseTimeChartData@histPerfBean@servletRequest"/>
        <oem:chartColumn
                displayLabel=""
                sourceIndex="0"
                isKey="true"/>
          <oem:chartColumn
                displayLabel=""
                sourceIndex="1"
                isTimeColumn="true"/>
          <oem:chartColumn
                displayLabel=""
                sourceIndex="2"/>
       </uix:contents>
     </oem:chart>

     <%--
     ================================
     == Disk Group Throughput
     ================================
     --%>
     <oem:chart titleBinding="THROUGHPUT@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="MB_PER_SECOND@OsmObjectBundle@servletRequest"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical">
       <uix:contents>
         <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                        defaultLabel="true" />
         <oem:boundChartDataSource
             chartDataSourceBinding="throughputChartData@histPerfBean@servletRequest"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>


     <%--
     ================================
     == Disk Group I/O Operations
     ================================
     --%>
     <oem:chart titleBinding="OPERATIONS_PS_TITLE@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="OPERATIONS_PS@OsmObjectBundle@servletRequest">
       <uix:contents>
        <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                        defaultLabel="true" />
         <oem:boundChartDataSource
             chartDataSourceBinding="IOPerSecondChartData@histPerfBean@servletRequest"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>


     <%--
     ================================
     == Disk Group I/O Size
     ================================
     --%>
     <oem:chart titleBinding="OP_SIZE@OsmObjectBundle@servletRequest"
                chartType="timeSeriesChart"
                format="svg"
                orientation="vertical"
                width="650"
                height="160"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="MB_PER_OPERATION@OsmObjectBundle@servletRequest"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical">
       <uix:contents>
        <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                        defaultLabel="true" />
         <oem:boundChartDataSource
             chartDataSourceBinding="IOSizeChartData@histPerfBean@servletRequest"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="0"
              isKey="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="1"
              isTimeColumn="true"/>
         <oem:chartColumn
              displayLabel=""
              sourceIndex="2"/>
       </uix:contents>
     </oem:chart>

     <%-- End New IO Size Chart --%>

   </uix:stackLayout>
</uix:dataScope>
</uix:buildTree>

