<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="osmMsgs" 
              class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
  <uix:body>
  <uix:form name="diskGeneral" method="post"
      destinationBinding="defaultURL@servletRequest">
  <uix:formValue name="pageName" value="/database/osm/diskGeneralPage"/>
  <uix:formValue name="mname" valueBinding="name@diskDetails@diskGrp@servletRequest"/>  

  <uix:pageLayout titleBinding="diskHeader@diskGrp@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="0">
          <uix:link textBinding="GENERAL@osmMsgs"/>
          <uix:link textBinding="PERFORMANCE@osmMsgs"
                     onClick="submitForm('diskGeneral', true, {event:'diskPerformanceTab'})" renderedBinding="showPerformanceTab@servletRequest"/>
      </uix:subTabBar>
    </uix:subTabs>
           <%-- ASM Rolling Migration Info --%>
       <uix:switcher childNameBinding="rollingMigrationStatus@diskGrp@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/infoicon_active.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_PERF_MESSAGE@OsmObjectBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>

    <uix:stackLayout>
      <uix:spacer height="20"/>
    <uix:rowLayout hAlign="top">
    <uix:cellFormat width="50%"> 
    <uix:labeledFieldLayout labelWidth="200">
      <uix:messagePrompt promptBinding="NAME@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="name@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="LABEL@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="label@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="PATH@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="path@diskDetails@diskGrp@servletRequest"/>
      
      <uix:messagePrompt promptBinding="FAILGROUP@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="failGroup@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="REDUNDANCY@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="redundancy@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="OS_SIZE_GB@osmMsgs"
                         renderedBinding="versionGte11g@diskGrp@servletRequest"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="OSMB@diskDetails@diskGrp@servletRequest"
                      renderedBinding="versionGte11g@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="TOTAL_GB@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="totalGB@diskDetails@diskGrp@servletRequest"/>
                      
      <uix:messagePrompt promptBinding="FREE_GB@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="freeGB@diskDetails@diskGrp@servletRequest"/>

      </uix:labeledFieldLayout>
    </uix:cellFormat>

    <uix:cellFormat width="50%" hAlign="top">
    <uix:stackLayout>
    <uix:labeledFieldLayout labelWidth="150">
      <uix:messagePrompt promptBinding="MOUNT_STATUS@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="mountStatus@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="HEADER_STATUS@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="headerStatus@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="MODE_STATUS@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="modeStatus@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="REMAINING_REPAIR_TIME_SEC@osmMsgs"
                         renderedBinding="showRepairTime@diskDetails@diskGrp@servletRequest"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="repairTimer@diskDetails@diskGrp@servletRequest"
                      renderedBinding="showRepairTime@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt prompt=""
                         renderedBinding="showRepairTime@diskDetails@diskGrp@servletRequest"/>
      <uix:styledText styleClass="OraTipText"
                      textBinding="REPAIR_TIME_TIP@osmMsgs"
                      renderedBinding="showRepairTime@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="STATE@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="state@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="MOUNT_DATE@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="mountDate@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="CREATE_DATE@osmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="createDate@diskDetails@diskGrp@servletRequest"/>

      <uix:messagePrompt promptBinding="GRID_DISK@osmMsgs"
                         renderedBinding="showGridDisk@diskDetails@diskGrp@servletRequest"/>
      <uix:link styleClass="OraDataText"
                textBinding="gridDisk@diskDetails@diskGrp@servletRequest"
                destinationBinding="gridDiskConfigUrl@diskDetails@diskGrp@servletRequest"
                renderedBinding="showGridDisk@diskDetails@diskGrp@servletRequest"/>

      </uix:labeledFieldLayout>
    </uix:stackLayout>
    </uix:cellFormat>
    </uix:rowLayout>
      <uix:spacer height="20"/>
    </uix:stackLayout>

    </uix:subTabLayout>
      </uix:pageLayout>
       </uix:form>
      </uix:body>
  </uix:document>
</uix:renderingContext>
