<%--
  -- Page:        diskGroupIOCumulative.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmHealthController
  --
  -- Description: ASM instance performance,
  --              Disk Group I/O Cumulative Statistics page
  --
  --  MODIFIED    (MM/DD/YY)
  --     dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --     asubba    10/02/07 - add diskzone cumulative statistics
  --     qsong     07/06/06 - 
  --     asubba    03/28/06 - 
  --     rajeshar  07/27/05 - bug 4410193
  --     rajeshar  03/30/05 - making UI review changes 
  --     rajeshar  02/04/05 - correcting the spelling mistake for defaultURL
  --     jochen    06/28/04 - jochen_mode_offline
  --     jochen    06/26/04 - Moved to separate page from Performance page
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundles --%>
<uix:bundle name="msgs"
            class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
<uix:bundle name="DBMsgs"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefreshRate") %> >
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoadBinding="focusJavaScript@servletRequest">
    <uix:pageLayout titleBinding="ioCumulativePageHeader@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:form name="osmHealth"
              method="get"
              destinationBinding="defaultURL@servletRequest">
      <uix:formValue name="pageName"
                     value="<%= JspConstants.OSM_IO_CUMULATIVE_PAGE %>"/>

      <%--
      ======================
      == Refresh settings
      ======================
      --%>
      <uix:tableLayout width="100%">
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <uix:contents>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="lastUpdatedTime@osmHealthBean@servletRequest"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                                    textBinding="REFRESH@msgs"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:choice id="refreshChoice"
                                name="refreshChoice"
                                selectedValueBinding="refreshChoice@osmHealthBean@servletRequest"
                                onChange="submitForm('osmHealth',true,{'event':'refreshChoice','pageIndex':'2'})">
                      <uix:option textBinding="REALTIME_MANUAL@msgs"
                                  value="<%= JspConstants.MANUAL_REFRESH %>" />
                      <uix:option textBinding="REALTIME_AUTO15@msgs"
                                  value="15"/>
                      <uix:option textBinding="REALTIME_AUTO30@msgs"
                                  value="30"/>
                    </uix:choice>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:submitButton name="event"
                                      textBinding="REFRESH@msgs"
                                      value="refresh"/>
                  </uix:cellFormat>

                </uix:rowLayout>
              </uix:tableLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <%--
      ============================
      == Cumulative stats table
      ============================
      --%>
      <uix:header>

        <%-- show instance startup time if instance bean is in the cache --%>
        <uix:switcher childNameBinding="showSinceTime@servletRequest">
          <uix:case name="true">
            <uix:flowLayout>
              <uix:styledText styleClass="OraPromptText"
                      textBinding="ACCUMULATED_SINCE@OsmObjectBundle@servletRequest"/>
              <uix:spacer width="8"/>
              <uix:styledText styleClass="OraDataText"
                      textBinding="sinceTime@servletRequest"/>
            </uix:flowLayout>
          </uix:case>
        </uix:switcher>
        
        <uix:hGrid id="statistics"
                   width="100%"
                   alternateTextBinding="DG_IO_ALT_TEXT@OsmObjectBundle@servletRequest"
                   destinationBinding="defaultURL@servletRequest"
                   summaryBinding="DG_IO_SUMMARY@OsmObjectBundle@servletRequest"
                   columnFormatsBinding="columnFormats@osmHealthBean@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@osmHealthBean@servletRequest"
                   treeDataBinding="treeData@osmHealthBean@servletRequest"
                   proxyBinding="proxy@servletRequest"
                   formSubmitted="true">
          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="DISKGROUPS@OsmObjectBundle@servletRequest"/>
              </uix:columnHeader>
              <uix:rowLayout>
                <uix:image sourceBinding="source"
                           heightBinding="height"
                           widthBinding="width"/>
                <uix:spacer width="5"/>
                <uix:styledText textBinding="text"
                                destinationBinding="destination"/>
              </uix:rowLayout>
            </uix:column>
          </uix:nodeStamp>

          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>

          <uix:styledText textBinding="response"/>
          <uix:styledText textBinding="throughput"/>
          <uix:styledText textBinding="io"/>
            <uix:columnGroup >
              <uix:columnHeader > <uix:styledText textBinding="READS@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                 <uix:columnHeader > <uix:styledText textBinding="TOTAL@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                   <uix:styledText textBinding="reads"/>
                  </uix:column>

                  <%-- The following columns are for 11g Trailblazer release --%>
                 
                 <uix:column renderedBinding="versionGte11gTB@osmHealthBean@servletRequest">
                  <uix:columnHeader > 
                    <uix:styledText textBinding="HOT@OsmObjectBundle@servletRequest"/> 
                  </uix:columnHeader>
                   <uix:styledText textBinding="hreads"/>
                  </uix:column>

                  <uix:column renderedBinding="versionGte11gTB@osmHealthBean@servletRequest">
                    <uix:columnHeader > 
                      <uix:styledText textBinding="COLD@OsmObjectBundle@servletRequest"/> 
                    </uix:columnHeader>
                    <uix:styledText textBinding="creads"/>
                  </uix:column>
                 
                  <uix:column >
                    <uix:columnHeader > 
                      <uix:styledText textBinding="ERRORS@OsmObjectBundle@servletRequest"/> 
                    </uix:columnHeader>
                    <uix:styledText textBinding="rerrs"/>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
           <uix:columnGroup >
              <uix:columnHeader > <uix:styledText textBinding="WRITES@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                    <uix:columnHeader > <uix:styledText textBinding="TOTAL@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                    <uix:styledText textBinding="writes"/> 
                  </uix:column>

                  <%-- The following columns are for 11g Trailblazer release --%>
                 
                  <uix:column renderedBinding="versionGte11gTB@osmHealthBean@servletRequest">
                    <uix:columnHeader > 
                      <uix:styledText textBinding="HOT@OsmObjectBundle@servletRequest"/> 
                    </uix:columnHeader>
                    <uix:styledText textBinding="hwrites"/>
                  </uix:column>

                  <uix:column renderedBinding="versionGte11gTB@osmHealthBean@servletRequest">
                    <uix:columnHeader > 
                      <uix:styledText textBinding="COLD@OsmObjectBundle@servletRequest"/> 
                    </uix:columnHeader>
                    <uix:styledText textBinding="cwrites"/>
                  </uix:column>
                  

                  <uix:column >
                    <uix:columnHeader > <uix:styledText textBinding="ERRORS@OsmObjectBundle@servletRequest"/> </uix:columnHeader>
                     <uix:styledText textBinding="werrs" />
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
        </uix:hGrid>
      </uix:header>

    </uix:form>
  </uix:pageLayout>
</uix:body>
</uix:document>
</uix:renderingContext>


