<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="msgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

  <uix:document>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefreshRate") %> >      
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    
    <uix:body onLoadBinding="focusJavaScript@servletRequest">
    <uix:pageLayout titleBinding="header@diskGrp@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:form name="editDGForm" 
      method="get" destinationBinding="defaultURL@servletRequest">

      <uix:formValue 
        name="pageName" 
        value="/database/osm/diskGroupPerformance"/>

     <uix:subTabLayout>
        <uix:subTabs>
          <jsp:include page="/database/osm/subTabsInclude.jsp" />
          <uix:ref refID="subTabsInclude" />           
        </uix:subTabs>

        <%-- Explanatory text if this is part of a RAC cluster --%>                
        <uix:spacer height="5"/>
        <uix:rowLayout>
          <uix:messagePrompt promptBinding="DG_CLUSTER_EXPLANATION@msgs"
              renderedBinding="hasMultipleInstances@diskGrp@servletRequest"/>
        </uix:rowLayout>

        <uix:switcher childNameBinding="enterpriseMode@servletRequest">
        <uix:case name="true">
          <uix:tableLayout width="100%" >
            <uix:rowLayout  hAlign="right"> 
                  <uix:cellFormat>
                  <uix:contents>
                   <uix:tableLayout cellSpacing="5" >
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:styledText styleClass="OraTipText"
                              textBinding="lastUpdatedTimeLabel@diskGrp@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                              <uix:styledText styleClass="OraTipLabel"
                                textBinding="lastUpdatedTime@diskGrp@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                      <uix:styledText labeledNodeId="viewChoice"
                                      styleClass="OraPromptText"
                                      textBinding="VIEW@msgs"/>
                    </uix:cellFormat>

                  <%-- The following are for 11g Trailblazer release --%>
                  <%--
                    <uix:cellFormat renderedBinding="versionGte11g@diskGrp@servletRequest">
                      <uix:choice id="viewChoice"
                                  name="viewChoice"
                                  selectedValueBinding="viewChoice@osmHealthBean@servletRequest"
                                  onChange="submitForm('osmHealth',true,{'event':'refreshviewChoice'})">
                        <uix:option textBinding="DEFAULT@msgs"
                                    value="IO" />

                        <uix:option textBinding="ZONE_IO_DETAILS@msgs"
                                    value="ZoneIo"/>
                        <uix:option textBinding="ZONE_READ_WRITE_DETAILS@msgs"
                                    value="ZoneReadWrite"/>
                        </uix:choice>
                    </uix:cellFormat>
                        <uix:cellFormat>
                        <uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                          textBinding="REFRESH@msgs"/>
                        </uix:cellFormat>                          
                  --%>
                        <uix:cellFormat>                        
                        <uix:choice id="viewChoice" name="refreshChoice" 
                              selectedValueBinding="refreshChoice@diskGrp@servletRequest"
                              onChange="submitForm('editDGForm',true,{'event':'refreshChoice'})"> 
                          <uix:option
                            textBinding="REALTIME_MANUAL@msgs"
                            value="100000000" />
                          <uix:option
                            textBinding="REALTIME_AUTO15@msgs"
                            value="15"/>
                          <uix:option
                            textBinding="REALTIME_AUTO30@msgs"
                            value="30"/>
                          <uix:option textBinding="LAST24@msgs"
                            value="<%= JspConstants.HIST_LAST_24_HR%>"/>
                          <uix:option textBinding="LAST7@msgs"
                            value="<%= JspConstants.HIST_LAST_7_DAYS%>"/>
                          <uix:option textBinding="LAST31@msgs"
                            value="<%= JspConstants.HIST_LAST_31_DAYS%>"/>
                        </uix:choice>
                        </uix:cellFormat>
                        <uix:cellFormat>                                                
                          <uix:submitButton
                          name="event" 
                          textBinding="REFRESH@msgs"
                          value="refresh"/>
                        </uix:cellFormat>                        
                    </uix:rowLayout>
                   </uix:tableLayout>
                </uix:contents>
              </uix:cellFormat>
          </uix:rowLayout>                                                  
          </uix:tableLayout>
        </uix:case>
        </uix:switcher>        

        <jsp:include page="/database/osm/osmHistPerformanceInclude.jsp"/>
        <uix:ref refID="osmHistPerformanceInclude"/>

        <uix:stackLayout renderedBinding="enterpriseMode@servletRequest"><!--begin main table -->     
              <oem:chart 
                  titleBinding="RESPONSE_TIME@msgs"
                  chartType="timeSeriesChart"
                  svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
                  format="svg"
                  orientation="vertical"
                  width="650"
                  height="160"
                  timeGranularity="SECOND"
                  seriesColorsAutomatic="true"
                  yAxisLabelBinding="MS_PER_OPERATION@msgs"                
                  legendPosition="east"            
                  legendVisible="external"
                  externalLegendOrientation="vertical"
                  showKeyInLegend="false"
                  renderedBinding="realTimeRefreshSelected@diskGroupHealthBean@servletRequest"
                  >
              <uix:contents>
                  <oem:rtChartDataSource 
                        targetBinding="targetName@diskGrp@servletRequest" 
                        targetTypeBinding="targetType@diskGrp@servletRequest" 
                        metricId="DiskGroup_Performance"
                  />
                      <oem:imageMap imageMapDataSourceBinding="responseImageDataSource@servletRequest" 
                        defaultLabel="true" />
                      <oem:chartColumn
                        displayLabel="DiskGroup Name"
                        isKey="true"                       
                        columnName="dg_name"
                        keyValueListBinding="keys@servletRequest"                    
                        />          
                      <oem:chartColumn
                        displayLabelBinding="IO_RESPONSE_TIME@msgs"
                        columnName="io_response_time"
                        /> 
                      <oem:chartColumn
                        displayLabelBinding="READ_RESPONSE_TIME@msgs"
                        columnName="read_response_time"
                        /> 
                      <oem:chartColumn
                        displayLabelBinding="WRITE_RESPONSE_TIME@msgs"
                        columnName="write_response_time"
                        /> 
                  
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Date"
                        sourceIndex="1"
                        />          
              </uix:contents>
            </oem:chart>

            <oem:chart 
                  titleBinding="THROUGHPUT@msgs"
                  chartType="timeSeriesChart"
                  svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
                  format="svg"
                  orientation="vertical"
                  width="650"
                  height="160"
                  timeGranularity="SECOND"
                  seriesColorsAutomatic="true"
                  yAxisLabelBinding="MB_PER_SECOND@msgs" 
                  legendPosition="east"            
                  legendVisible="external"
                  externalLegendOrientation="vertical"
                  showKeyInLegend="false"
                  renderedBinding="realTimeRefreshSelected@diskGroupHealthBean@servletRequest"
                  >
              <uix:contents>
                  <oem:rtChartDataSource 
                        targetBinding="targetName@diskGrp@servletRequest" 
                        targetTypeBinding="targetType@diskGrp@servletRequest" 
                        metricId="DiskGroup_Performance"/>
                      <oem:imageMap imageMapDataSourceBinding="throughputImageDataSource@servletRequest" 
                        defaultLabel="true" />

                      <oem:chartColumn
                        displayLabel="DiskGroup Name"
                        isKey="true"                       
                        columnName="dg_name"
                        keyValueListBinding="keys@servletRequest"                    
                        />          
                      <oem:chartColumn
                        displayLabelBinding="IO_THROUGHPUT@msgs"
                        columnName="io_throughput"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="READ_THROUGHPUT@msgs"
                        columnName="read_throughput"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="WRITE_THROUGHPUT@msgs"
                        columnName="write_throughput"
                        />          
                  
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Date"
                        sourceIndex="1"
                        />          
              </uix:contents>
            </oem:chart>

              <oem:chart 
                  titleBinding="OPERATIONS_PS_TITLE@msgs"
                  chartType="timeSeriesChart"
                  svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
                  format="svg"
                  orientation="vertical"
                  width="650"
                  height="160"
                  timeGranularity="SECOND"
                  seriesColorsAutomatic="true"
                  yAxisLabelBinding="OPERATIONS_PS@msgs"     
                  legendPosition="east"            
                  legendVisible="external"
                  externalLegendOrientation="vertical"
                  showKeyInLegend="false"
                  renderedBinding="realTimeRefreshSelected@diskGroupHealthBean@servletRequest"
                  >
              <uix:contents>
                  <oem:rtChartDataSource 
                        targetBinding="targetName@diskGrp@servletRequest" 
                        targetTypeBinding="targetType@diskGrp@servletRequest" 
                        metricId="DiskGroup_Performance"
                  />
                      <oem:imageMap imageMapDataSourceBinding="operationsImageDataSource@servletRequest" 
                        defaultLabel="true" />
            
                      <oem:chartColumn
                        displayLabel="DiskGroup Name"
                        isKey="true"                       
                        columnName="dg_name"
                        keyValueListBinding="keys@servletRequest"                    
                        />          
                      <oem:chartColumn
                        displayLabelBinding="IO_UOM@msgs"
                        columnName="io_ps"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="READS_PS@msgs"
                        columnName="reads_ps"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="WRITES_PS@msgs"
                        columnName="writes_ps"
                        />          
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Date"
                        sourceIndex="1"
                        />          
              </uix:contents>
            </oem:chart>

            <%-- I/O Size (# I/O per operation) --%>
            <oem:chart 
                titleBinding="OP_SIZE@msgs"
                chartType="timeSeriesChart"
                format="svg"
                svgUpdateFrequencyBinding="refreshChoice@osmHealthBean@servletRequest"
                orientation="vertical"
                width="650"
                height="160"
                timeGranularity="SECOND"
                seriesColorsAutomatic="true"
                yAxisLabelBinding="MB_PER_OPERATION@msgs"
                legendPosition="east"
                legendVisible="external"
                externalLegendOrientation="vertical"
                showKeyInLegend="false"
                renderedBinding="realTimeRefreshSelected@diskGroupHealthBean@servletRequest"
                >
            <uix:contents>
              <oem:rtChartDataSource
                    targetBinding="targetName@diskGrp@servletRequest" 
                    targetTypeBinding="targetType@diskGrp@servletRequest" 
                    metricId="DiskGroup_Performance"
                  />
                  <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                        defaultLabel="true" />
                      <oem:chartColumn
                        displayLabelBinding="DISKGROUP@msgs"
                        isKey="true"                       
                        columnName="dg_name"
                        keyValueListBinding="keys@servletRequest"                    
                        />          
                      <oem:chartColumn
                        displayLabelBinding="IO_SIZE@msgs"
                        columnName="io_size"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="READ_SIZE@msgs"
                        columnName="read_size"
                        />          
                      <oem:chartColumn
                        displayLabelBinding="WRITE_SIZE@msgs"
                        columnName="write_size"
                        />          
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Date"
                        sourceIndex="1"
                        />
                </uix:contents>
              </oem:chart>
              
        </uix:stackLayout>


        <uix:header textBinding="DG_IO_CUMULATIVE_SUMMARY@msgs"
                    renderedBinding="realTimeRefreshSelected@healthBean@servletRequest">

	        <%-- show instance startup time if instance bean is in the cache --%>
	        <uix:switcher childNameBinding="showSinceTime@servletRequest">
	          <uix:case name="true">
              <uix:flowLayout>
                <uix:styledText styleClass="OraPromptText"
                       textBinding="ACCUMULATED_SINCE@msgs"/>
                <uix:spacer width="8"/>
                <uix:styledText styleClass="OraDataText"
                     textBinding="sinceTime@servletRequest"/>
              </uix:flowLayout>
	          </uix:case>
	        </uix:switcher>
          
           <uix:hGrid id="statistics"
                     width="100%"
                     alternateTextBinding="DG_IO_ALT_TEXT@msgs"
                     destinationBinding="defaultUrl@servletRequest"
                     summaryBinding="DG_IO_SUMMARY@msgs"
                     columnFormatsBinding="columnFormats@diskGroupHealthBean@servletRequest"
                     columnHeaderDataBinding="columnHeaderData@diskGroupHealthBean@servletRequest"
                     treeDataBinding="treeData@diskGroupHealthBean@servletRequest"
                     proxyBinding="proxy@servletRequest"
                             formSubmitted="true">
            <uix:nodeStamp>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="MEMBER_DISKS@msgs"/>
                </uix:columnHeader>
                <uix:rowLayout  >
                  <uix:image sourceBinding="source" 
                             shortDescBinding="MEMBER_DISKS@msgs"
                            heightBinding="height" 
                            widthBinding="width"/>
                  <uix:spacer width="5"/>                          
                  <uix:styledText textBinding="text"
                                destinationBinding="destination"/>
                 </uix:rowLayout>                                         
              </uix:column>
            </uix:nodeStamp>

            <uix:columnHeaderStamp>
              <uix:text textBinding="text"/>
            </uix:columnHeaderStamp>

            <uix:styledText textBinding="response"/>          
            <uix:styledText textBinding="throughput"/>                    
            <uix:styledText textBinding="io"/>               
            
            <uix:columnGroup >
              <uix:columnHeader > <uix:styledText textBinding="READS@msgs"/> </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                 <uix:columnHeader > <uix:styledText textBinding="TOTAL@msgs"/> </uix:columnHeader>
                   <uix:styledText textBinding="reads"/>
                  </uix:column>

                  <%-- The following columns are for 11g Trailblazer release --%>
                  
                 <uix:column renderedBinding="versionGte11gTB@diskGroupHealthBean@servletRequest">
                  <uix:columnHeader > 
                    <uix:styledText textBinding="HOT@msgs"/> </uix:columnHeader>
                   <uix:styledText textBinding="hreads"/>
                  </uix:column>
                  <uix:column renderedBinding="versionGte11gTB@diskGroupHealthBean@servletRequest">
                  <uix:columnHeader > 
                    <uix:styledText textBinding="COLD@msgs"/> </uix:columnHeader>
                  <uix:styledText textBinding="creads"/>
                  </uix:column>
                  
                  <uix:column >
                  <uix:columnHeader > 
                    <uix:styledText textBinding="ERRORS@msgs"/> </uix:columnHeader>
                    <uix:styledText textBinding="rerrs"/>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
              
              <uix:columnGroup >
              <uix:columnHeader > <uix:styledText textBinding="WRITES@msgs"/> </uix:columnHeader>
               <uix:contents >
                 <uix:column >
                    <uix:columnHeader > <uix:styledText textBinding="TOTAL@msgs"/> </uix:columnHeader>
                    <uix:styledText textBinding="writes"/> 
                  </uix:column>

                  <%-- The following columns are for 11g Trailblazer release --%>
                  
                  <uix:column renderedBinding="versionGte11gTB@diskGroupHealthBean@servletRequest">
                    <uix:columnHeader > 
                      <uix:styledText textBinding="HOT@msgs"/> </uix:columnHeader>
                    <uix:styledText textBinding="hwrites"/>
                  </uix:column>
                  <uix:column renderedBinding="versionGte11gTB@diskGroupHealthBean@servletRequest">
                    <uix:columnHeader > 
                      <uix:styledText textBinding="COLD@msgs"/> </uix:columnHeader>
                    <uix:styledText textBinding="cwrites"/>
                  </uix:column>
                 
                  <uix:column >
                    <uix:columnHeader > <uix:styledText textBinding="ERRORS@msgs"/> </uix:columnHeader>
                     <uix:styledText textBinding="werrs" />
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>
                      
          </uix:hGrid>
        </uix:header> 

      </uix:subTabLayout>
     </uix:form>
    </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

