<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.osm.MemberDisksDataSource" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />
<uix:bundle name="osmMsgs"
            class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body onLoadBinding="focusJavaScript@servletRequest">
      <uix:pageLayout titleBinding="header@diskGrp@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <db:form name="editDGForm" method="post" destination="/console/database/osm/diskGroup"
	        copyParams="target,type,oname">

      <uix:formValue name="pageName" value="<%= JspConstants.VOLUMES_PAGE %>"/>
     <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:switcher childNameBinding="isShowResizeOfsLink@servletRequest">
          <uix:case name="false">
     	    <oem:messageBox messageType="error" errorTableBinding="error@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:case>
          <uix:case name="true">
            <uix:messageBox messageType="error" messageBinding="errorMsg@servletRequest" >
		  <uix:link textBinding="showResizeOfsText@servletRequest" destinationBinding="showResizeOfsLink@servletRequest" />
            </uix:messageBox>		
          </uix:case>
        </uix:switcher>
        <uix:switcher childNameBinding="isShowCreateOfsLink@servletRequest">
          <uix:case name="false">
	        <oem:messageBox messageType="confirmation" errorTableBinding="confirmation@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
          </uix:case>
          <uix:case name="true">
            <uix:messageBox messageType="confirmation" messageBinding="confirmationMsg@servletRequest" >
		  <uix:link textBinding="showCreateOfsText@servletRequest" destinationBinding="showCreateOfsLink@servletRequest" />
            </uix:messageBox>		
          </uix:case>
        </uix:switcher>

     <uix:subTabLayout>
        <uix:subTabs>
         <jsp:include page="/database/osm/subTabsInclude.jsp" />
              <uix:ref refID="subTabsInclude" />            
        </uix:subTabs>
        <uix:tableLayout width="100%" >
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" vAlign="top" width="100%">
             <uix:pageButtonBar>
              <uix:submitButton textBinding="CREATE@ofsMsg" 
                                shortDescBinding="CREATE@ofsMsg" 
                                name="event" 
                                value="<%= Constant.EVENT_CREATE_VOLUME %>"/>
                <uix:switcher childNameBinding="haveData@volumeBean@servletRequest">
                  <uix:case name="1">
                    <uix:submitButton textBinding="ENABLE_ALL@ofsMsg" 
                                      shortDescBinding="ENABLE_ALL@ofsMsg" 
                                      name="event" 
                                      value="<%= Constant.EVENT_ENABLE_ALL_VOLUME %>"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="haveData@volumeBean@servletRequest">
                  <uix:case name="1">
                    <uix:submitButton textBinding="DISABLE_ALL@ofsMsg" 
                                      shortDescBinding="DISABLE_ALL@ofsMsg" 
                                      name="event" 
                                      value="<%= Constant.EVENT_DISABLE_ALL_VOLUME %>"/>
                  </uix:case>
                </uix:switcher>
             </uix:pageButtonBar>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left" vAlign="top" width="100%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="INST_DSKGRP_VOL@ofsMsg"/>

            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:table summaryBinding="VOLUME@ofsMsg"
	    		 width="100%" 
                   formSubmitted="true"
                   id="volumeDataSource"
                   tableDataBinding="tableData@volumeBean@servletRequest"
                   valueBinding="startIndex@volumeBean@servletRequest"
                   maxValueBinding="length@volumeBean@servletRequest"
                   blockSizeBinding="blockSize@volumeBean@servletRequest"
                   showAllBinding="showAll@volumeBean@servletRequest"
                   alternateTextBinding="NO_OBJECT_FOUND@ofsMsg">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:tableSelection>
            <uix:multipleSelection selectedBinding="isSelected@volumeBean@servletRequest" shortDescBinding="SELECT@ofsMsg">
              <uix:pageButtonBar>
                <uix:submitButton textBinding="ENABLE@ofsMsg" name="event" value="<%= Constant.EVENT_ENABLE_VOLUME %>" shortDescBinding="ENABLE@ofsMsg"/>
                <uix:submitButton textBinding="DISABLE@ofsMsg" name="event" value="<%= Constant.EVENT_DISABLE_VOLUME %>" shortDescBinding="DISABLE@ofsMsg"/>
                <uix:submitButton textBinding="EDIT@ofsMsg" name="event" value="<%= Constant.EVENT_EDIT_VOLUME %>" shortDescBinding="EDIT@ofsMsg"/>
                <uix:submitButton textBinding="CREATE_OFS@ofsMsg" name="event" value="<%= Constant.EVENT_CREATE_OFS %>" shortDescBinding="CREATE_OFS@ofsMsg"/>
                <uix:submitButton textBinding="VIEW@ofsMsg" name="event" value="<%= Constant.EVENT_VIEW_VOLUME %>" shortDescBinding="VIEW@ofsMsg"/>
                <uix:submitButton textBinding="DELETE@ofsMsg" name="event" value="<%= Constant.EVENT_DELETE_VOLUME %>" shortDescBinding="DELETE@ofsMsg"/>
              </uix:pageButtonBar>
            </uix:multipleSelection>
          </uix:tableSelection>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="VOLUME@ofsMsg" sortableBinding="sortColumn0@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="volName@volumeBean@servletRequest" destinationBinding="viewVolumeURL@volumeBean@servletRequest" />
            <uix:formValue name="selectValue" valueBinding="volName@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="VOLUME_DEVICE@ofsMsg" sortableBinding="sortColumn1@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="volDevice@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="STATE@ofsMsg" sortableBinding="sortColumn2@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="state@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="USAGE@ofsMsg" sortableBinding="sortColumn3@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="usage@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="MOUNT_POINT@ofsMsg" sortableBinding="sortColumn4@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="mountPoint@volumeBean@servletRequest" destinationBinding="ofsURL@volumeBean@servletRequest" />
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="SIZE_GB@ofsMsg" sortableBinding="sortColumn5@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:styledText textBinding="totalSize@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="DG_ALLOC_SPACE_GB@ofsMsg" sortableBinding="sortColumn6@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:styledText textBinding="DgAllocatedSpace@volumeBean@servletRequest"/>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="REDUNDANCY@ofsMsg" sortableBinding="sortColumn7@volumeBean@servletRequest"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="redundancyLocale@volumeBean@servletRequest"/>
          </uix:column>

        </uix:table>

      </uix:subTabLayout>
     </db:form>
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

