<%--
  -- Page:        diskGroups.jsp
  -- Controller:  oracle.sysman.db.adm.osm.OsmAdminController
  --
  -- Description: ASM instance Administration tab - disk groups
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  03/20/09 - replace incorrect USERS_SUMMARY
  --     asubba    09/12/08 - fix logging issues
  --     dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --     chanchan  02/14/08 - Add related links
  --     asubba    10/28/07 - XbranchMerge asubba_asm_message_issues from main
  --     asubba    09/11/07 - fix the fonts for unmounted disk
  --     chanchan  07/16/07 - Hide/show OFS tab
  --     asubba    05/28/07 - XbranchMerge asubba_bug-5886001_main from main
  --     asubba    03/15/07 - XbranchMerge asubba_bug-5886001 from
  --     qsong     03/06/07 - hide rebalance column
  --     gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --     qsong     01/19/07 - remove requires rebalance column
  --     qsong     01/19/07 - remove requires rebalance column
  --     asubba    01/08/07 - XbranchMerge asubba_asm_bugs from main
  --     asubba    12/15/06 - add mount all tip
  --     yozhang   11/27/06 - fix ADA issues
  --     qsong     11/03/06 - 
  --     asubba    10/27/06 - hide users tab from non sysasm user
  --     qsong     10/27/06 - 
  --     qsong     10/17/06 - 
  --     chanchan  06/05/06 - Add OFS tab
  --     chanchan  05/09/06 - 
  --     qsong     02/23/06 - add metadata backup restore buttons
  --     asubba    09/11/06 - rolling migration
  --     qsong     07/20/06 - 
  --     asubba    07/18/06 - 
  --     qsong     06/29/06 - 
  --     asubba    06/19/06 - Enable multiselection 
  --     qsong     06/06/06 - 
  --     qsong     06/06/06 - 
  --     asubba    03/21/06 - add buttons for dropdown 
  --     qsong     02/23/06 - add metadata backup restore buttons
  --     rajeshar  04/26/05 - putting summary binding for table, ADA issue
  --     rajeshar  02/03/05 - using oemTitle for pageHeader
  --     chanchan  10/19/04 - Add ASM licensing 
  --     jochen    07/14/04 - Only show offline tip if offline disks
  --     jochen    06/26/04 - Add tip for offline disks
  --     many      ?        - Many edits by many people
  --     spanchum  08/22/02 - Creation
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.osm.ofs.Constant" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.osm.OsmConst" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
<uix:bundle name="ofsMsg" class="oracle.sysman.db.rsc.osm.ofs.OfsObjectMsg" />

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:form
      name="osmForm"
      method="GET"
      destinationBinding="defaultURL@servletRequest">
      <uix:formValue
        name="pageName"
        value="/database/osm/diskGroups"/>
        <uix:pageLayout titleBinding="header@osmAdminBean@servletRequest">
           <%-- <uix:header textBinding="header@osmAdminBean@servletRequest"> --%>
             <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>           
          <%--                                                          --%>
          <%-- Support pageMsgBox for any apps that return to this page --%>
          <%-- and support it.  This include must be positioned AFTER   --%>
          <%-- any other uix:messages or messageBox tags.               --%>
          <%--                                                          --%>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
     <uix:subTabLayout>
     <%-- If user is currently connected to the db instance, don't show the tabs --%>
     <% 
       Object fromDB = request.getAttribute("accessViaAsmConnection");
       if ( fromDB != null && ((Boolean)fromDB).booleanValue() == true){
     %>
        <uix:subTabs>
          <uix:switcher childNameBinding="enterpriseMode@servletRequest">
            <uix:case name="true">
              <uix:subTabBar selectedIndex="2">
                <uix:link textBinding="HOME@dbMsgs"
                    destinationBinding="sitemapDest@servletRequest"
                    renderedBinding="showOsmHomePage@servletRequest"/>
               <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@dbMsgs"
                    destinationBinding="healthDest@servletRequest"
                    renderedBinding="showOsmPerfPage@servletRequest"/>
               </oem:license>
               <uix:link textBinding="DISKGROUPS@osmMsgs"/>
               <uix:link textBinding="CONFIGURATION@dbMsgs"
                    destinationBinding="configDest@servletRequest"
                    renderedBinding="showOsmConfigPage@servletRequest"/>
               <uix:link textBinding="USERS@osmMsgs"
                    destinationBinding="usersDest@servletRequest"/>
                <uix:link textBinding="ORACLE_FILE_SYSTEM@ofsMsg" renderedBinding="showOfs@servletRequest"
                    destinationBinding="ofsDest@servletRequest"/>
              </uix:subTabBar>
            </uix:case>

          <uix:case name="false">
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="ADMINISTRATION@dbMsgs"/>
              <uix:link textBinding="CONFIGURATION@dbMsgs"
                  destinationBinding="configDest@servletRequest"/>
            </uix:subTabBar>
          </uix:case>
        </uix:switcher>
      </uix:subTabs>
      <% } %>

      <%-- ASM access warning message --%>
      <jsp:include page="/database/osm/asmAccessWarningInclude.jsp" />
      <uix:ref refID="asmAccessWarningInclude"/>
       <%-- ASM Rolling Migration Info --%>
       <uix:switcher childNameBinding="rollingMigrationStatus@osmAdminBean@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/infoicon_active.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="ROLLING_MIGRATION_REBAL_MESSAGE@osmMsgs"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>
      <%-- uix:header textBinding="DISKGROUPS@OsmObjectBundle@servletRequest" --%>
        <uix:stackLayout>
          <uix:tableLayout width="100%">
           <uix:rowLayout >
          <uix:spacer width="5"/>
          </uix:rowLayout>
            <uix:rowLayout hAlign="left"
                           renderedBinding="showOfflineTip@osmAdminBean@servletRequest">
              <uix:cellFormat hAlign="left">
                <uix:rowLayout>
                  <uix:image source="<%= request.getContextPath() + \"/images/down.gif\" %>"/>
                  <uix:cellFormat vAlign="center">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OFFLINE_DISKS@OsmObjectBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="right">
              <%-- <uix:tip renderedBinding="verGE102@osmAdminBean@servletRequest">
                <contents>
                  <uix:styledText styleClass="oraTipText"
                                  textBinding="USABLE_INSTR@OsmObjectBundle@servletRequest"/>
                </contents>
              </uix:tip>  --%>
              <uix:cellFormat>
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CREATE@uixDBObjectBundle@servletRequest"
                                    name="event" 
                                    value="create"
                                    disabledBinding="disableNonSysAsmOp@servletRequest"/>

                  <%--   metadata backup/restore features have been postponed to later release --%>
                  <%-- 
                  <uix:submitButton textBinding="BACKUP_CONFIGURATION@OsmObjectBundle@servletRequest"
                                    renderedBinding="verGE11g@osmAdminBean@servletRequest"
                                    name="event" value="<%= OsmConst.EVENT_BACKUP %>"/>
                  <uix:submitButton textBinding="RESTORE_CONFIGURATION@OsmObjectBundle@servletRequest"
                                    renderedBinding="verGE11g@osmAdminBean@servletRequest"
                                    name="event" value="<%= OsmConst.EVENT_RESTORE%>"/>
                  --%>

                  <uix:submitButton textBinding="MOUNT_ALL@OsmObjectBundle@servletRequest"
                                    name="event" 
                                    value="mountAll"
                                    disabledBinding="disableNonSysAsmOp@servletRequest"/>
                  <uix:submitButton textBinding="DISMOUNT_ALL@OsmObjectBundle@servletRequest"
                                    name="event" 
                                    value="dismountAll"
                                    disabledBinding="disableNonSysAsmOp@servletRequest"/>
                </uix:pageButtonBar>
              </uix:cellFormat>
            </uix:rowLayout>
	        </uix:tableLayout>
	        <uix:spacer height="5"/>
          <uix:dataScope currentDataBinding="diskGroupsDataSource@osmAdminBean@servletRequest">
                 <uix:table id="diskGroupsDataSource" 
                                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
                                formSubmitted="true" width="100%" 
                                tableDataBinding="rowData" 
                                minValue="1" 
                                valueBinding="startIndex"
                                maxValueBinding="numRows" 
                                blockSizeBinding="blockSize"
                                summaryBinding="DISKGROUP_SUMMARY@OsmObjectBundle@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                       <uix:tableSelection>
                        <uix:multipleSelection  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" 
                                                selectedBinding="select">
                          <uix:pageButtonBar>
                            <uix:submitButton textBinding="MOUNT@OsmObjectBundle@servletRequest" 
                                              name="event" 
                                              value="MOUNT"
                                              disabledBinding="disableNonSysAsmOp@servletRequest"/>
                            <uix:submitButton textBinding="DISMOUNT@OsmObjectBundle@servletRequest" 
                                              name="event" 
                                              value="DISMOUNT"
                                              disabledBinding="disableNonSysAsmOp@servletRequest"/>
                            <uix:submitButton textBinding="REBALANCE@OsmObjectBundle@servletRequest" 
                                              name="event" 
                                              value="REBALANCE"
                                              disabledBinding="disableNonSysAsmOp@servletRequest"/>
                              <uix:submitButton renderedBinding="verGE11@osmAdminBean@servletRequest"
                                              textBinding="CHECK@OsmObjectBundle@servletRequest" 
                                              name="event" 
                                              value="CHECK"
                                              disabledBinding="disableNonSysAsmOp@servletRequest"/>
                            <uix:submitButton textBinding="DELETE@uixDBObjectBundle@servletRequest" 
                                              name="event" 
                                              value="delete"
                                              disabledBinding="disableNonSysAsmOp@servletRequest"/>
                            </uix:pageButtonBar>
                        </uix:multipleSelection>
                      </uix:tableSelection>
                      <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="NAME@OsmObjectBundle@servletRequest" sortableBinding="sortName"/>
                          </uix:columnHeader>
                             <uix:flowLayout>
                              <uix:contents>
                              <uix:spacer width="1"/>
                                  <uix:image sourceBinding="source" shortDescBinding="NAME@OsmObjectBundle@servletRequest"/>
                                 <uix:spacer width="5"/>
                                <uix:styledText textBinding="name" destinationBinding="dgUrl"/> 
                              </uix:contents>
                             </uix:flowLayout>  
                                               
                      </uix:column>
                      <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="STATE@OsmObjectBundle@servletRequest" sortableBinding="sortState"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:text textBinding="state"/>
                      </uix:column>
                       <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="REDUNDANCY@OsmObjectBundle@servletRequest" sortableBinding="sortRedundancy"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:text textBinding="redundancy"/>
                      </uix:column>
                       <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="SIZE_GB@OsmObjectBundle@servletRequest" sortableBinding="sortSizeGB"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:text textBinding="sizeGB"/>
                      </uix:column>
                      <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="USED_GB@OsmObjectBundle@servletRequest" sortableBinding="sortUsedGB"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:text textBinding="usedGB"/>
                      </uix:column>
                       <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="USED_PERCENT@OsmObjectBundle@servletRequest" shortDescBinding="USED_PERCENT@OsmObjectBundle@servletRequest" sortableBinding="sortUsedPct"/>
                          </uix:columnHeader>
                           <uix:contents>
                               <uix:flowLayout>
                              <uix:separator>
                                  <uix:spacer width="1" height="0"/>
                              </uix:separator>
                              <uix:contents>
                                  <uix:include nodeBinding="usedPctImg"/>
                                  <uix:text textBinding="usedPct"/>
                              </uix:contents>
                             </uix:flowLayout>
                          </uix:contents>
                      </uix:column>
                       <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="USABLE_FREE_GB@OsmObjectBundle@servletRequest" sortableBinding="sortUsableFreeGB"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:text textBinding="usableFreeGB"/>
                      </uix:column>
                      <%-- uix:column renderedBinding="verGE11@osmAdminBean@servletRequest">
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="FRAGMENTATION@OsmObjectBundle@servletRequest" sortableBinding="sortFragmentation"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:text textBinding="fragmentation"/>
                      </uix:column> --%>
                      <%--
                         <uix:column renderedBinding="verGE11@osmAdminBean@servletRequest">
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="REQUIRES_REBALANCE@OsmObjectBundle@servletRequest" sortableBinding="sortRequiresRebalance"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat"/>
                          <uix:link textBinding="requiresRebalance" destinationBinding="rebalanceUrl"/>
                      </uix:column> 
                      --%>
                       <uix:column>
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="MEMBER_DISKS@OsmObjectBundle@servletRequest" sortableBinding="sortMemberDiskCount"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:text textBinding="memberDiskCount"/>
                      </uix:column>
                     
                      <uix:column renderedBinding="verLE102@osmAdminBean@servletRequest">
                          <uix:columnHeader>
                              <uix:sortableHeader textBinding="PENDING_OPERATIONS@OsmObjectBundle@servletRequest" sortableBinding="sortMemberDiskCount"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:link textBinding="pendingOperations" destinationBinding="operationsUrl"/>
                      </uix:column>
                      
                      
                       <uix:formValue name="NAME" valueBinding="name"/>
                    </uix:table>
            </uix:dataScope>
         <uix:spacer height="5"/>
         <uix:tip renderedBinding="verGE102@osmAdminBean@servletRequest">
                <contents>
                  <uix:styledText styleClass="oraTipText"
                                  textBinding="USABLE_INSTR@OsmObjectBundle@servletRequest"/>
                </contents>
              </uix:tip>
              <uix:tip renderedBinding="verGE102@osmAdminBean@servletRequest">
                <contents>
                  <uix:styledText styleClass="oraTipText"
                                  textBinding="MOUNT_ALL_TIP@OsmObjectBundle@servletRequest"/>
                </contents>
              </uix:tip>
        </uix:stackLayout>
      <%-- /uix:header --%>
      
    </uix:subTabLayout>
    <uix:tableLayout>
      <oem:relatedLinks />
    </uix:tableLayout>
    </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

