<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="msgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>

  <uix:document>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefreshRate") %> >      
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body onLoadBinding="focusJavaScript@servletRequest">
    <uix:pageLayout titleBinding="byInstanceTitle@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <uix:form name="foo" 
      method="get" destinationBinding="defaultURL@servletRequest">
  <uix:formValue name="pageName" value="/database/osm/diskPerformanceByInstance"/>
  <uix:formValue name="mname" valueBinding="name@diskDetails@diskGrp@servletRequest"/>  
  <uix:formValue name="lastByInstanceEvent" valueBinding="event@servletRequest"/>

     <uix:subTabLayout>  
     
        <uix:labeledFieldLayout labelWidth="20%">
          <uix:messagePrompt promptBinding="OSM@msgs"/>
          <uix:styledText styleClass="OraDataText"
                    textBinding="targetName@diskGrp@servletRequest"/>
          <uix:messagePrompt promptBinding="DISKGROUP@msgs"/>
          <uix:styledText styleClass="OraDataText"
                    textBinding="name@diskGrp@servletRequest"/>
          <uix:messagePrompt promptBinding="MEMBER_DISK@msgs"/>
          <uix:styledText styleClass="OraDataText"
                    textBinding="name@diskDetails@diskGrp@servletRequest"/>
        </uix:labeledFieldLayout>
        <uix:separator/>      

        <uix:switcher childNameBinding="enterpriseMode@servletRequest">
        <uix:case name="true">
          <uix:tableLayout width="100%" >
            <uix:rowLayout  hAlign="right"> 
                  <uix:cellFormat>
                  <uix:contents>
                   <uix:tableLayout cellSpacing="5" >
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:styledText styleClass="OraTipText"
                              textBinding="lastUpdatedTimeLabel@diskGrp@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                              <uix:styledText styleClass="OraTipLabel"
                                textBinding="lastUpdatedTime@diskGrp@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                        <uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                          textBinding="REFRESH@msgs"/>
                        </uix:cellFormat>                          
                        <uix:cellFormat>                        
                        <uix:choice id="refreshChoice" name="refreshChoice" 
                              selectedValueBinding="refreshChoice@diskGrp@servletRequest"
                              onChange="submitForm('foo',true,{'event':'refreshChoice'})"> 
                          <uix:option
                            textBinding="REALTIME_MANUAL@msgs"
                            value="100000000" />
                          <uix:option
                            textBinding="REALTIME_AUTO15@msgs"
                            value="15"/>
                          <uix:option
                            textBinding="REALTIME_AUTO30@msgs"
                            value="30"/>
                          <uix:option textBinding="LAST24@msgs"
                            value="<%= JspConstants.HIST_LAST_24_HR%>"/>
                          <uix:option textBinding="LAST7@msgs"
                            value="<%= JspConstants.HIST_LAST_7_DAYS%>"/>
                          <uix:option textBinding="LAST31@msgs"
                            value="<%= JspConstants.HIST_LAST_31_DAYS%>"/>
                        </uix:choice>
                        </uix:cellFormat>
                        <uix:cellFormat>                                                
                          <uix:submitButton
                          name="event" 
                          textBinding="REFRESH@msgs"
                          value="refresh"/>
                        </uix:cellFormat>                        
                    </uix:rowLayout>
                   </uix:tableLayout>
                </uix:contents>
              </uix:cellFormat>
          </uix:rowLayout>                                                  
          </uix:tableLayout>
        </uix:case>
        </uix:switcher>

        <uix:tableLayout width="100%"> <!--begin main table -->     
          <uix:switcher childNameBinding="enterpriseMode@servletRequest">
            <uix:case name="true">
              <uix:rowLayout vAlign="top">
                <jsp:include page="/database/osm/instHistPerformanceInclude.jsp"/>
                <uix:ref refID="instHistPerformanceInclude"/>
              </uix:rowLayout> 
            </uix:case> 
          </uix:switcher> 
          <uix:switcher childNameBinding="enterpriseMode@servletRequest">
          <uix:case name="true">
            <uix:rowLayout vAlign="top">
              <oem:chart titleBinding="byInstanceTitle@servletRequest"
                  chartType="timeSeriesChart"
                  format="svg"
                  svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
                  orientation="vertical"
                  width="650"
                  height="200"
                  timeGranularity="SECOND"
                  seriesColorsAutomatic="true"
		              yAxisLabelBinding="byInstanceAxis@servletRequest"    
                  legendPosition="south"            
                  renderedBinding="realTimeRefreshSelected@diskGrp@servletRequest"
                  >
              <uix:contents>
                  <oem:boundChartDataSource 
                       chartDataSourceBinding="realTimePerformance@diskGrp@servletRequest"/>
                  <oem:imageMap imageMapDataSourceBinding="instanceImageDataSource@servletRequest"
                        overwriteLabels="true" defaultLabel="true" />
                    <oem:chartColumn
                        displayLabel="Instance Name"
                        isKey="true"
                        sourceIndex="0"
                        />
                      <oem:chartColumn
                        displayLabel=""
                        sourceIndexBinding="sourceIndex@servletRequest"
                        />
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Date"
                        sourceIndex="1"
                        />
              </uix:contents>
            </oem:chart>
                  
          
          
            </uix:rowLayout>
            </uix:case>
          </uix:switcher>    
        </uix:tableLayout> <!--end main table -->     
      </uix:subTabLayout>
     </uix:form>
    </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

