<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.adm.osm.JspConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="msgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
  <uix:document>
    <uix:metaContainer>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("pageRefreshRate") %> >      
    </uix:metaContainer>
    
    <%@ include file="/oemTitle.jspf" %>     
    
  <uix:body onLoadBinding="focusJavaScript@servletRequest">
  <uix:form name="diskPerm" method="get" 
    destinationBinding="defaultURL@servletRequest">
  <uix:formValue name="pageName" value="/database/osm/diskProp"/>
  <uix:formValue name="mname" valueBinding="name@diskDetails@diskGrp@servletRequest"/>  

  <uix:pageLayout titleBinding="diskHeader@diskGrp@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="1">
          <uix:link text="General"
                    onClick="submitForm('diskPerm', true, {event:'diskProp'})"/>
          <uix:link text="Performance"/>
      </uix:subTabBar>
    </uix:subTabs>

      <%-- Explanatory if this is part of a RAC cluster --%>
      <uix:spacer height="5"/>
      <uix:rowLayout>
        <uix:messagePrompt promptBinding="DG_CLUSTER_EXPLANATION@msgs"
            renderedBinding="hasMultipleInstances@diskGrp@servletRequest"/>
      </uix:rowLayout>
    
     <uix:switcher childNameBinding="enterpriseMode@servletRequest">
     <uix:case name="true">
        <uix:tableLayout width="100%" >
          <uix:rowLayout  hAlign="right"> 
            <uix:cellFormat>
              <uix:contents>
                <uix:tableLayout cellSpacing="5" >
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraTipText"
                              textBinding="lastUpdatedTimeLabel@diskGrp@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraTipLabel"
                                textBinding="lastUpdatedTime@diskGrp@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:cellFormat>
                        <uix:styledText labeledNodeId="viewChoice"
                                        styleClass="OraPromptText"
                                        textBinding="VIEW@msgs"/>
                      </uix:cellFormat>

                    <%-- The following are for 11g Trailblazer release --%>
                    <%--
                      <uix:cellFormat renderedBinding="versionGte11g@diskGrp@servletRequest">
                        <uix:choice id="viewChoice"
                                    name="viewChoice"
                                    selectedValueBinding="viewChoice@osmHealthBean@servletRequest"
                                    onChange="submitForm('diskPerm',true,{'event':'refreshChoice'})">
                          <uix:option textBinding="DEFAULT@msgs"
                                      value="IO" />
                          <uix:option textBinding="ZONE_IO_DETAILS@msgs"
                                      value="ZoneIo"/>
                          <uix:option textBinding="ZONE_READ_WRITE_DETAILS@msgs"
                                      value="ZoneReadWrite"/>
                       </uix:choice>
                      </uix:cellFormat>
                    --%>
                      <%-- uix:styledText labeledNodeId="refreshChoice" styleClass="OraPromptText"
                        textBinding="REFRESH@msgs"/ --%>
                    </uix:cellFormat>                          
                    <uix:cellFormat>                        
                      <uix:choice id="viewChoice" name="refreshChoice" 
                            selectedValueBinding="refreshChoice@diskGrp@servletRequest"
                            onChange="submitForm('diskPerm',true,{'event':'refreshChoice'})"> 
                        <uix:option
                          textBinding="REALTIME_MANUAL@msgs"
                          value="100000000" />
                        <uix:option
                          textBinding="REALTIME_AUTO15@msgs"
                          value="15"/>
                        <uix:option
                          textBinding="REALTIME_AUTO30@msgs"
                          value="30"/>
                        <uix:option textBinding="LAST24@msgs"
                            value="<%= JspConstants.HIST_LAST_24_HR%>"/>
                        <uix:option textBinding="LAST7@msgs"
                            value="<%= JspConstants.HIST_LAST_7_DAYS%>"/>
                        <uix:option textBinding="LAST31@msgs"
                            value="<%= JspConstants.HIST_LAST_31_DAYS%>"/>
                      </uix:choice>
                      </uix:cellFormat>
                      <uix:cellFormat>                                                
                        <uix:submitButton
                        name="event" 
                        textBinding="REFRESH@msgs"
                        value="refresh"/>
                      </uix:cellFormat>                        
                  </uix:rowLayout>
                 </uix:tableLayout>
              </uix:contents>
            </uix:cellFormat>
        </uix:rowLayout>                                                  
        </uix:tableLayout>
     </uix:case>
     </uix:switcher>     

     <jsp:include page="/database/osm/osmHistPerformanceInclude.jsp"/>
     <uix:ref refID="osmHistPerformanceInclude"/>

     <uix:stackLayout renderedBinding="enterpriseMode@servletRequest">
        <oem:chart 
            titleBinding="RESPONSE_TIME@msgs"
            chartType="timeSeriesChart"
            svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
            format="svg"
            orientation="vertical"
            width="650"
            height="160"
            timeGranularity="SECOND"
            seriesColorsAutomatic="true"
            yAxisLabelBinding="MS_PER_OPERATION@msgs"                
            legendPosition="east"            
            legendVisible="external"
            externalLegendOrientation="vertical"
            showKeyInLegend="false"
            renderedBinding="realTimeRefreshSelected@diskGrp@servletRequest"
            >
        <uix:contents>
            <oem:rtChartDataSource 
                  targetBinding="targetName@diskGrp@servletRequest" 
                  targetTypeBinding="targetType@diskGrp@servletRequest" 
                  metricId="Disk_Performance"
            />
                <oem:imageMap imageMapDataSourceBinding="responseImageDataSource@servletRequest" 
                  defaultLabel="true"/>
                <oem:chartColumn
                  displayLabel="Disk Name"
                  isKey="true"                       
                  columnNameListBinding="keyCols@servletRequest"
                  keyValueListBinding="keys@servletRequest"                    
                  />          
                <oem:chartColumn
                  displayLabelBinding="IO_RESPONSE_TIME@msgs"
                  columnName="io_response_time"
                  /> 
                <oem:chartColumn
                  displayLabelBinding="READ_RESPONSE_TIME@msgs"
                  columnName="read_response_time"
                  /> 
                <oem:chartColumn
                  displayLabelBinding="WRITE_RESPONSE_TIME@msgs"
                  columnName="write_response_time"
                  /> 
                  
                <oem:chartColumn
                  isTimeColumn="true"
                  displayLabel="Date"
                  sourceIndex="1"
                  />          
        </uix:contents>
      </oem:chart>

      <oem:chart 
            titleBinding="THROUGHPUT@msgs"
            chartType="timeSeriesChart"
            svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
            format="svg"
            orientation="vertical"
            width="650"
            height="160"
            timeGranularity="SECOND"
            seriesColorsAutomatic="true"
            yAxisLabelBinding="MB_PER_SECOND@msgs" 
            legendPosition="east"            
            legendVisible="external"
            externalLegendOrientation="vertical"
            showKeyInLegend="false"
            renderedBinding="realTimeRefreshSelected@diskGrp@servletRequest"
            >
        <uix:contents>
            <oem:rtChartDataSource 
                  targetBinding="targetName@diskGrp@servletRequest" 
                  targetTypeBinding="targetType@diskGrp@servletRequest" 
                  metricId="Disk_Performance"
            />
                <oem:imageMap imageMapDataSourceBinding="throughputImageDataSource@servletRequest" 
                  defaultLabel="true"/> 
                <oem:chartColumn
                  displayLabel="Disk Name"
                  isKey="true"                       
                  columnNameListBinding="keyCols@servletRequest"
                  keyValueListBinding="keys@servletRequest"                    
                  />          
                <oem:chartColumn
                  displayLabelBinding="IO_THROUGHPUT@msgs"
                  columnName="io_throughput"
                  />          
                <oem:chartColumn
                  displayLabelBinding="READ_THROUGHPUT@msgs"
                  columnName="read_throughput"
                  />          
                <oem:chartColumn
                  displayLabelBinding="WRITE_THROUGHPUT@msgs"
                  columnName="write_throughput"
                  />          
                  
                <oem:chartColumn
                  isTimeColumn="true"
                  displayLabel="Date"
                  sourceIndex="1"
                  />          
        </uix:contents>
      </oem:chart>

        <oem:chart 
            titleBinding="OPERATIONS_PS_TITLE@msgs"
            chartType="timeSeriesChart"
            svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
            format="svg"
            orientation="vertical"
            width="650"
            height="160"
            timeGranularity="SECOND"
            seriesColorsAutomatic="true"
            yAxisLabelBinding="OPERATIONS_PS@msgs"     
            legendPosition="east"            
            legendVisible="external"
            externalLegendOrientation="vertical"
            showKeyInLegend="false"
            renderedBinding="realTimeRefreshSelected@diskGrp@servletRequest"
            >
        <uix:contents>
            <oem:rtChartDataSource 
                  targetBinding="targetName@diskGrp@servletRequest" 
                  targetTypeBinding="targetType@diskGrp@servletRequest" 
                  metricId="Disk_Performance"
            />
                <oem:imageMap imageMapDataSourceBinding="operationsImageDataSource@servletRequest" 
                  defaultLabel="true"/>            
                <oem:chartColumn
                  displayLabel="Disk Name"
                  isKey="true"                       
                  columnNameListBinding="keyCols@servletRequest"
                  keyValueListBinding="keys@servletRequest"                    
                  />          
                <oem:chartColumn
                  displayLabelBinding="IO_UOM@msgs"
                  columnName="io_ps"
                  />          
                <oem:chartColumn
                  displayLabelBinding="READS_PS@msgs"
                  columnName="reads_ps"
                  />          
                <oem:chartColumn
                  displayLabelBinding="WRITES_PS@msgs"
                  columnName="writes_ps"
                  />          
                <oem:chartColumn
                  isTimeColumn="true"
                  displayLabel="Date"
                  sourceIndex="1"
                  />          
        </uix:contents>
      </oem:chart>

      <oem:chart 
            titleBinding="OP_SIZE@msgs"
            chartType="timeSeriesChart"
            svgUpdateFrequencyBinding="refreshChoice@diskGrp@servletRequest"
            format="svg"
            orientation="vertical"
            width="650"
            height="160"
            timeGranularity="SECOND"
            seriesColorsAutomatic="true"
            yAxisLabelBinding="MB_PER_OPERATION@msgs"     
            legendPosition="east"            
            legendVisible="external"
            externalLegendOrientation="vertical"
            showKeyInLegend="false"
            renderedBinding="realTimeRefreshSelected@diskGrp@servletRequest"
            >
        <uix:contents>
            <oem:rtChartDataSource 
                  targetBinding="targetName@diskGrp@servletRequest" 
                  targetTypeBinding="targetType@diskGrp@servletRequest" 
                  metricId="Disk_Performance"
            />
                <oem:imageMap imageMapDataSourceBinding="sizeImageDataSource@servletRequest" 
                  defaultLabel="true"/>            
                <oem:chartColumn
                  displayLabel="Disk Name"
                  isKey="true"                       
                  columnNameListBinding="keyCols@servletRequest"
                  keyValueListBinding="keys@servletRequest"                    
                  />          
                <oem:chartColumn
                  displayLabelBinding="IO_SIZE@msgs"
                  columnName="io_size"
                  />          
                <oem:chartColumn
                  displayLabelBinding="READ_SIZE@msgs"
                  columnName="read_size"
                  />          
                <oem:chartColumn
                  displayLabelBinding="WRITE_SIZE@msgs"
                  columnName="write_size"
                  />          
                <oem:chartColumn
                  isTimeColumn="true"
                  displayLabel="Date"
                  sourceIndex="1"
                  />          
        </uix:contents>
      </oem:chart>
  </uix:stackLayout>
<!-- uix:switcher childNameBinding="versionGte11g@diskGrp@servletRequest" -->
 <!-- uix:case name="true" -->

 <%--
  <uix:tableLayout>    
   <uix:rowLayout vAlign="top">  
     <uix:header textBinding="DISK_IO_STATISTICS@msgs">                    
     <uix:tableLayout cellSpacing="5"> 
         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_RESPONSE_TIME@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgRespTime@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_THROUGHPUT@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgThroughput@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding="TOTAL_IO@msgs" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
           <uix:styledText styleClass="OraDataText" textBinding="totalIO@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>
     
         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding="TOTAL_READS@msgs" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
           <uix:styledText styleClass="OraDataText" textBinding="reads@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="TOTAL_WRITES@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="writes@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="TOTAL_READ_ERRS@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="readErrors@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="TOTAL_WRITE_ERRS@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="writeErrors@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

     </uix:tableLayout>  
   </uix:header>                   
   </uix:rowLayout>    
  </uix:tableLayout> 
  --%>

  <!-- /uix:case -->
<!--Begin Statistics -->
<!-- uix:case name="false" -->
<uix:header textBinding="CUMULATIVE_STATISTICS@msgs"
            renderedBinding="realTimeRefreshSelected@healthBean@servletRequest">
  <uix:rowLayout width="100%">
  <uix:spacer width="10"/>
  <uix:tableLayout width="100%">
  <uix:rowLayout >
  <!-- I/O -->  
  <uix:cellFormat vAlign="top" >
   <uix:header textBinding="IO@msgs">
     <uix:tableLayout cellSpacing="5">    
         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_RESPONSE_TIME@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgRespTime@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_THROUGHPUT@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgThroughput@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
           <uix:messagePrompt promptBinding="TOTAL_IO@msgs" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
           <uix:styledText styleClass="OraDataText" textBinding="totalIO@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>
     
         </uix:tableLayout>
         </uix:header>
        </uix:cellFormat>
        <!--Read-->
        <uix:cellFormat vAlign="top">
          <uix:header textBinding="READ@msgs">
           <uix:tableLayout cellSpacing="5">    
              <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_RESPONSE_TIME@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgReadRespTime@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_THROUGHPUT@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgReadThroughput@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>
         
             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
               <uix:messagePrompt promptBinding="TOTAL_READ_ERRS@msgs"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
               <uix:styledText styleClass="OraDataText" textBinding="readErrors@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
             </uix:rowLayout>
          
            <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="TOTAL_READS@msgs" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                 <uix:styledText styleClass="OraDataText" textBinding="reads@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
               
            <%-- The following are for 11g Trailblazer release --%>
            
            <uix:rowLayout renderedBinding="versionGte11gTB@diskGrp@servletRequest">
              <uix:cellFormat hAlign="right">
               <uix:messagePrompt promptBinding="HOT_READS@msgs"/>
               </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" 
                                textBinding="hreads@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
          
            <uix:rowLayout renderedBinding="versionGte11gTB@diskGrp@servletRequest">
             <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="COLD_READS@msgs" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                 <uix:styledText styleClass="OraDataText" textBinding="creads@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
           

           </uix:tableLayout>
          </uix:header>
        </uix:cellFormat>
         <!--Write-->
        <uix:cellFormat vAlign="top">
                  <uix:header textBinding="WRITE@msgs">
           <uix:tableLayout cellSpacing="5">
           <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_RESPONSE_TIME@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgWriteRespTime@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="AVG_THROUGHPUT@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="avgWriteThroughput@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>
         
              
              <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                 <uix:messagePrompt promptBinding="TOTAL_WRITE_ERRS@msgs"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left">
                 <uix:styledText styleClass="OraDataText" textBinding="writeErrors@diskDetails@diskGrp@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              
              <uix:rowLayout>
                 <uix:cellFormat hAlign="right">
                 <uix:messagePrompt promptBinding="TOTAL_WRITES@msgs"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left">
                 <uix:styledText styleClass="OraDataText" textBinding="writes@diskDetails@diskGrp@servletRequest" />
                </uix:cellFormat>
             </uix:rowLayout>
               

             <%-- The following are for 11g Trailblazer release --%>
            
             <uix:rowLayout renderedBinding="versionGte11gTB@diskGrp@servletRequest">
               <uix:cellFormat hAlign="right">
               <uix:messagePrompt promptBinding="HOT_WRITES@msgs"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
               <uix:styledText styleClass="OraDataText" textBinding="hwrites@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
             </uix:rowLayout>
          
            <uix:rowLayout renderedBinding="versionGte11gTB@diskGrp@servletRequest">
             <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="COLD_WRITES@msgs" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                 <uix:styledText styleClass="OraDataText" textBinding="cwrites@diskDetails@diskGrp@servletRequest" />
              </uix:cellFormat>
           </uix:rowLayout>
           
            
           </uix:tableLayout>
          </uix:header>

        </uix:cellFormat>
        </uix:rowLayout>
       
        </uix:tableLayout>

    </uix:rowLayout>
   </uix:header> 
   <!-- /uix:case -->

<uix:header textBinding="EXADATA@msgs"
            renderedBinding="showGridDisk@diskDetails@diskGrp@servletRequest">
  <uix:rowLayout width="100%">
  <uix:spacer width="2"/>
  <uix:tableLayout width="100%">
  <uix:rowLayout >

  <uix:cellFormat vAlign="top" >

     <uix:tableLayout cellSpacing="5">    
         <uix:rowLayout>
         <uix:cellFormat hAlign="left">
         <uix:messagePrompt promptBinding="GRID_DISK@msgs"/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
         <uix:link styleClass="OraDataText" 
                   textBinding="gridDisk@diskDetails@diskGrp@servletRequest"
                   destinationBinding="gridDiskPerfUrl@diskDetails@diskGrp@servletRequest" />
        </uix:cellFormat>
         </uix:rowLayout>
             
           </uix:tableLayout>

        </uix:cellFormat>
        </uix:rowLayout>
       
        </uix:tableLayout>

    </uix:rowLayout>
   </uix:header> 
   <uix:spacer height="10"/>
   <!-- /uix:switcher -->
<!-- End Statistics -->
    </uix:subTabLayout>
    </uix:pageLayout>
     </uix:form>
    </uix:body>
</uix:document>
</uix:renderingContext>
