<%--
  -- Page:        editAdvanceAttributes.jsp
  -- Controller:  oracle.sysman.db.adm.osm.DiskGroupController
  --
  -- Description: ASM disk group edit advance attributes page
  --
  --  MODIFIED    (MM/DD/YY)
  --   asubba      02/04/09 - oac: fix the labels
  --   asubba      01/12/09 - hide ACL info for NT
  --   yozhang     12/05/08 - Fix bug 7623381: smart scan capability
  --   asubba      08/18/08 - 
  --   chanchan    08/11/08 - 
  --   asubba      07/29/08 - advance attribute default
  --   chanchan    07/02/08 - Add compatible.advm support
  --   dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
  --                          st_emdbsa_11.1
  --   asubba      03/08/07 - XbranchMerge asubba_22705_umask_sysoper from
  --                          st_emdbsa_project-22846
  --   gmahaney    02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
  --   yozhang     12/15/06 - Remove days and seconds from repair time choices
  --                          list
  --   asubba      01/12/07 - 
  --   yozhang     11/30/06 - fix ADA issues
  --   asubba      09/27/06 - External redundancy disk
  --   qsong       05/30/06 - 
  --   asubba      03/06/06 - Initial entry
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
   <%@ include file="/oemTitle.jspf" %>
    <uix:body> 
    <uix:form
      name="diskGrpForm"
      method="post"
      destinationBinding="defaultURL@servletRequest">

      <uix:formValue
        name="pageName"
        value="/database/osm/editAdvanceAttributes"/>
         <uix:formValue name="optionChoice" valueBinding="optionChoice@servletRequest"/>
         <%--<uix:formValue name="oname" valueBinding="oname@servletRequest"/>--%>
         <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
        
      
      <uix:pageLayout titleBinding="editAdvanceAttrHeader@diskGrp@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout  width="80%">

                <%-----------------------------------%>
                <%---  Disk Group Compatibility   ---%>
                <%-----------------------------------%>
               
             <uix:rowLayout >
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:header textBinding="DISKGROUP_COMPATIBILITY@OsmObjectBundle@servletRequest" >
                    <uix:stackLayout >
                    <uix:messagePrompt 
                              promptBinding="DISKGROUP_COMPATIBILITY_INSTR@OsmObjectBundle@servletRequest"/>
                    <uix:spacer height="15"/>
                    <uix:rowLayout>
                    <uix:spacer height="15"/>
                    
                    <uix:tableLayout cellSpacing="10">
                      
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          labeledNodeId="databaseCompatibility"
                                          textBinding="DATABASE_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
		                        <uix:contents>
                              <uix:textInput id="databaseCompatibility"
                                             name="databaseCompatibility"
                                             textBinding="databaseCompatibility@diskGrp@servletRequest"
                                             columns="30"/>
                               <uix:onSubmitValidater>
                                <uix:decimal maxScale="0"/>
                               </uix:onSubmitValidater>

                    	       <uix:messageText messageBinding="(DATABASE_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
			                         <uix:styledText textBinding="DATABASE_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest"
                                               styleClass="OraInlineInfoText"/>
		                       </uix:contents>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          labeledNodeId="asmCompatibility"
                                          textBinding="ASM_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
		                        <uix:contents>
                              <uix:textInput id="asmCompatibility"
                                             name="asmCompatibility"
                                             textBinding="asmCompatibility@diskGrp@servletRequest"
                                             columns="30"/>
                     	      <uix:messageText messageBinding="(ASM_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
			                         <uix:styledText textBinding="ASM_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest"
                                               styleClass="OraInlineInfoText"/>
		                       </uix:contents>
                        </uix:stackLayout>
                       </uix:rowLayout>
                      
                      <uix:rowLayout vAlign="top" renderedBinding="isVersionGte11gTB@diskGrp@servletRequest">
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          labeledNodeId="advmCompatibility"
                                          textBinding="ADVM_COMPATIBILITY@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
		                        <uix:contents>
                              <uix:textInput id="advmCompatibility"
                                             name="advmCompatibility"
                                             textBinding="advmCompatibility@diskGrp@servletRequest"
                                             columns="30"/>
                              <uix:messageText messageBinding="(ADVM_COMPATIBILITY@OsmObjectBundle@servletRequest)@errors@servletRequest" messageType="error" />
                              <uix:styledText textBinding="ADVM_COMPATIBILITY_HINT@OsmObjectBundle@servletRequest" styleClass="OraInlineInfoText"/>
		                       </uix:contents>
                        </uix:stackLayout>
                       </uix:rowLayout>
                      
                    </uix:tableLayout>
                    </uix:rowLayout>
                     
                   <uix:rowLayout>
                   <uix:spacer width="51" height="1"/>
                    <uix:tip>
                      <contents> 
	  	        <uix:switcher childNameBinding="versionGte11gTB@diskGrp@servletRequest">
			  <uix:case name="true">    	
	                    <uix:styledText styleClass="oraTipText" textBinding="DISKGROUP_AVDM_COMPATIBILITY_TIP@OsmObjectBundle@servletRequest"/>
 			  </uix:case>				
			  <uix:default>    	
                  	    <uix:styledText styleClass="oraTipText" textBinding="DISKGROUP_COMPATIBILITY_TIP@OsmObjectBundle@servletRequest"/>
 	   		  </uix:default>				
	 	        </uix:switcher>             
                      </contents>
                     </uix:tip>
                  </uix:rowLayout>
                  </uix:stackLayout >
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
              
                <%---------------------------%>
                <%--- DISK REPAIR TIME    ---%>
                <%---------------------------%>
               
             <uix:rowLayout renderedBinding="showDisRepairTime@diskGrp@servletRequest">
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right" vAlign="top" >
                  <uix:header textBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest" >
                    <uix:stackLayout >
                    <uix:messagePrompt 
                              promptBinding="DISK_REPAIR_TIME_INSTR@OsmObjectBundle@servletRequest"/>
                    <uix:spacer height="15"/>
                    <uix:rowLayout>
                    <uix:spacer height="50"/>
                    
                    <uix:tableLayout cellSpacing="10"> 
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                           <uix:styledText labeledNodeId="idDiskRepairTime" 
                                           textBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest" 
                                           styleClass="OraPromptText" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="middle">
                               <uix:textInput  name="diskRepairTime" id="idDiskRepairTime"
                                               textBinding="diskRepairTime@diskGrp@servletRequest" columns="4"/>
                               <uix:stackLayout>
                                 <uix:choice id="DiskRepairTimeOption" name="diskRepairTimeOption"
                                                shortDescBinding="DISK_REPAIR_TIME@OsmObjectBundle@servletRequest"
                                                selectedValueBinding="diskRepairTimeOption@diskGrp@servletRequest">
                                           <%-- uix:option textBinding="SECONDS@OsmObjectBundle@servletRequest" value="s"/ --%> 
                                               <uix:option textBinding="MINUTES@OsmObjectBundle@servletRequest" value="m"/> 
                                               <uix:option textBinding="HOURS@OsmObjectBundle@servletRequest" value="h"/> 
                                               <%-- uix:option textBinding="DAYS@OsmObjectBundle@servletRequest" value="d"/ --%> 
                                 </uix:choice>
                                 <uix:messageText messageBinding="diskRepairTime@errors@servletRequest"
                                                  messageType="error"/>
			                          <uix:styledText textBinding="DISK_REPAIR_TIME_HINT@OsmObjectBundle@servletRequest"
                                                  styleClass="OraInlineInfoText"/>
                               </uix:stackLayout>
                        </uix:cellFormat>   
                      </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:rowLayout>
                   </uix:stackLayout >
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
              
          </uix:tableLayout>
           <%-----------------------------------%>
            <%---  Smart Scan Capability     ---%>
            <%-----------------------------------%>
               
             <uix:rowLayout renderedBinding="versionGte11gSmartScan@diskGrp@servletRequest">
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:header textBinding="SMART_SCAN_CAPABILITY_HEADER@OsmObjectBundle@servletRequest" >
                    <uix:tableLayout cellSpacing="10">
                      <uix:rowLayout vAlign="top">
                        <uix:stackLayout>
                          <uix:contents>
                            
                              <uix:radioButton
                                name="smartScanCapability"
                                textBinding="SMART_SCAN_NOT_DEFINED@OsmObjectBundle@servletRequest" 
                                disabledBinding="smartScanNotDefinedDisabled@diskGrp@servletRequest"
                                value="NOT_DEFINED" 
                                selectedValueBinding="smartScanCapability@diskGrp@servletRequest"/>                                                     
                                <uix:styledText textBinding="SMART_SCAN_NOT_DEINFED_HINT@OsmObjectBundle@servletRequest"
                                                styleClass="OraInlineInfoText"/>
                              
                              <uix:radioButton
                                name="smartScanCapability"
                                textBinding="SMART_SCAN_DISABLED@OsmObjectBundle@servletRequest" 
                                disabled="FALSE"
                                value="FALSE" 
                                selectedValueBinding="smartScanCapability@diskGrp@servletRequest"/>
                                <uix:styledText textBinding="SMART_SCAN_DISABLED_HINT@OsmObjectBundle@servletRequest"
                                                styleClass="OraInlineInfoText"/>
                                                
                              <uix:radioButton
                                name="smartScanCapability"
                                textBinding="SMART_SCAN_ENABLED@OsmObjectBundle@servletRequest" 
                                disabledBinding="smartScanEnabledDisabled@diskGrp@servletRequest"
                                value="TRUE" 
                                selectedValueBinding="smartScanCapability@diskGrp@servletRequest"/>
                                <uix:styledText textBinding="SMART_SCAN_ENABLED_HINT@OsmObjectBundle@servletRequest"
                                                styleClass="OraInlineInfoText"/>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
           <%-----------------------------------%>
            <%---  FILE ACCESS CONTROL   ---%>
            <%-----------------------------------%>
               
             <uix:rowLayout renderedBinding="showEditACL@servletRequest">
                <%---  Prompt  ---%>
                <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:header textBinding="FILE_ACCESS_CONTROL@OsmObjectBundle@servletRequest" >
                    <uix:stackLayout >
                    <uix:messagePrompt 
                              prompt=""/>
                    <uix:spacer height="15"/>
                    <uix:rowLayout>
                    <uix:spacer height="15" width="40"/>
                    
                    <uix:tableLayout cellSpacing="10">
                      
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="FILE_ACCESS_CONTROL@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:contents>
                            
                              <uix:radioButton
                                name="enableAccessControl"
                                textBinding="ENABLED@OsmObjectBundle@servletRequest" value="TRUE" selectedValueBinding="enableAccessControl@diskGrp@servletRequest"/>
                                                     <uix:styledText textBinding="ENABLE_FILE_ACCESS_CONTROL_HINT@OsmObjectBundle@servletRequest"
                                                   styleClass="OraInlineInfoText"/>
                              
                              <uix:radioButton
                                name="enableAccessControl"
                                textBinding="DISABLED@OsmObjectBundle@servletRequest" value="FALSE" selectedValueBinding="enableAccessControl@diskGrp@servletRequest"/>
                                                     <uix:styledText textBinding="DISABLE_FILE_ACCESS_CONTROL_HINT@OsmObjectBundle@servletRequest"
                                                   styleClass="OraInlineInfoText"/>
                               </uix:contents>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      
                      <uix:rowLayout vAlign="top">
                        <uix:cellFormat hAlign="right">
                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="DEFAULT_FILE_PERMISSION@OsmObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
		                        <uix:contents>
                                        <uix:messageText messageBinding="asmCompatibility@errors@servletRequest"
                                                messageType="error"/>
			                         <uix:styledText textBinding="DEFAULT_FILE_PERMISSION_HINT@OsmObjectBundle@servletRequest"
                                               styleClass="OraInlineInfoText"/>
                                        <uix:rowLayout>
                                        <uix:tableLayout>
                                         <uix:rowLayout>
                                         <uix:cellFormat>
                                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="USER@OsmObjectBundle@servletRequest"/>
                                          </uix:cellFormat>
                                          <uix:spacer width="5"/>
                                         <uix:cellFormat>
                               <uix:choice id="userMask" name="userMask"
                                              shortDescBinding="USER@OsmObjectBundle@servletRequest"
                                              selectedValueBinding="UserMask@diskGrp@servletRequest">
                                       <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="0"/> 
                                      <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="2"/> 
                                      <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="6"/>
                                   </uix:choice>
                                   </uix:cellFormat>
                                    </uix:rowLayout>
                                      <uix:rowLayout>
                                         <uix:cellFormat>
                                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="GROUP@OsmObjectBundle@servletRequest"/>
                                          </uix:cellFormat>
                                           <uix:spacer width="5"/>
                                         <uix:cellFormat>
                               <uix:choice id="groupMask" name="groupMask"
                                              shortDescBinding="GROUP@OsmObjectBundle@servletRequest"
                                              selectedValueBinding="groupMask@diskGrp@servletRequest">
                                      <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="0"/> 
                                      <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="2"/> 
                                      <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="6"/> 
                                   </uix:choice>
                                   </uix:cellFormat>
                                    </uix:rowLayout>
                                      <uix:rowLayout>
                                         <uix:cellFormat>
                                          <uix:styledText styleClass="OraPromptText"
                                          textBinding="OTHER@OsmObjectBundle@servletRequest"/>
                                          </uix:cellFormat>
                                           <uix:spacer width="5"/>
                                         <uix:cellFormat>
                               <uix:choice id="otherMask" name="otherMask"
                                              shortDescBinding="OTHER@OsmObjectBundle@servletRequest"
                                              selectedValueBinding="otherMask@diskGrp@servletRequest">
                                      <uix:option textBinding="READ_WRITE@OsmObjectBundle@servletRequest" value="0"/> 
                                      <uix:option textBinding="READ_ONLY@OsmObjectBundle@servletRequest" value="2"/> 
                                      <uix:option textBinding="NONE@OsmObjectBundle@servletRequest" value="6"/>
                                   </uix:choice>
                                   </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                                </uix:rowLayout>
                               
		                       </uix:contents>
                        </uix:stackLayout>
                       </uix:rowLayout>
                      
                    </uix:tableLayout>
                    </uix:rowLayout>
                     
                  </uix:stackLayout >
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
              

        <%-------------------------
         -  Footer
         ---------------------------%>
       <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton name="event"
                              textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              value="showSql"/>
            <uix:button   textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          destinationBinding="cancelURL@servletRequest"/>
            <uix:submitButton
              name="event"
              textBinding="OK@uixDBObjectBundle@servletRequest"
              value="apply"/>
          </uix:pageButtonBar>
         </uix:pageButtons>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
